#
# Script designed to be tested from inside the CamiTK Python interpreter using PythonManager::runScript
# See TestPythonScript.cpp
# 
# The requirements (if any) must defined in the the QRC file
#
import camitk

# get a known action
action = camitk.Application.getAction("Resample")
assert str(type(action)) == "<class 'camitk.Action'>"
assert action.getName() == "Resample"

# test parameter values
assert action.getParameterValue("New Image X Dimension") == 256
action.setParameterValue("New Image X Dimension", -1)
assert action.getParameterValue("New Image X Dimension") == -1

# test camitk property
prop = action.getProperty("New Image X Dimension")
assert prop.getName() == "New Image X Dimension"
assert prop.getDescription() == "The new image width (in voxels)."
assert prop.getUnit() == ""
assert prop.getReadOnly() == False
assert prop.getAttribute("minimum") == 1
assert prop.getAttribute("maximum") == 2**31 - 1 # set as std::numeric_limits<int>::max() in the Resample action constructor
assert prop.getAttribute("singleStep") == 1
prop.setAttribute("minimum", -42)
assert prop.getAttribute("minimum") == -42
prop.setAttribute("maximum", 0)
assert prop.getAttribute("maximum") == 0
prop.setAttribute("singleStep", 5)
assert prop.getAttribute("singleStep") == 5
prop.setReadOnly(True)
assert prop.getReadOnly() == True