
include ("${RunCMake_SOURCE_DIR}/check_errors.cmake")
unset (errors)

cmake_path (APPEND path "/a/b" "c")
if (NOT path STREQUAL "/a/b/c")
  list (APPEND errors "'${path}' instead of '/a/b/c'")
endif()

set (path "/a/b")
cmake_path (APPEND path "c")
if (NOT path STREQUAL "/a/b/c")
  list (APPEND errors "'${path}' instead of '/a/b/c'")
endif()

cmake_path (APPEND path "x/y" "z" OUTPUT_VARIABLE output)
if (NOT path STREQUAL "/a/b/c")
  list (APPEND errors "input changed unexpectedly")
endif()
if (NOT output STREQUAL "/a/b/c/x/y/z")
  list (APPEND errors "'${output}' instead of '/a/b/c/x/y/z'")
endif()

set (path "a")
cmake_path (APPEND path "")
if (NOT path STREQUAL "a/")
  list (APPEND errors "'${path}' instead of 'a/'")
endif()

cmake_path (APPEND path "/b")
if (NOT path STREQUAL "/b")
  list (APPEND errors "'${path}' instead of '/b'")
endif()

if (WIN32)
  set (path "a")
  cmake_path (APPEND path "c:/b")
  if (NOT path STREQUAL "c:/b")
    list (APPEND errors "'${path}' instead of 'c:/b'")
  endif()

  set (path "a")
  cmake_path (APPEND path "c:")
  if (NOT path STREQUAL "c:")
    list (APPEND errors "'${path}' instead of 'c:'")
  endif()
  cmake_path (APPEND path "")
  if (NOT path STREQUAL "c:")
    list (APPEND errors "'${path}' instead of 'c:'")
  endif()

  set (path "c:a")
  cmake_path (APPEND path "/b")
  if (NOT path STREQUAL "c:/b")
    list (APPEND errors "'${path}' instead of 'c:/b'")
  endif()

  set (path "c:a")
  cmake_path (APPEND path "c:b")
  if (NOT path STREQUAL "c:a/b")
    list (APPEND errors "'${path}' instead of 'c:a/b'")
  endif()

  set (path "//host")
  cmake_path (APPEND path "b")
  if (NOT path STREQUAL "//host/b")
    list (APPEND errors "'${path}' instead of '//host/b'")
  endif()

  set (path "//host/")
  cmake_path (APPEND path "b")
  if (NOT path STREQUAL "//host/b")
    list (APPEND errors "'${path}' instead of '//host/b'")
  endif()
endif()

check_errors (APPEND ${errors})
