#!/usr/bin/env dnsjit
-- Test that Label.torfc1035 produces correct output for non-printable QNAMEs
local pcap = arg[2]

local object = require("dnsjit.core.objects")
local input = require("dnsjit.input.pcap").new()
local layer = require("dnsjit.filter.layer").new()
local dns = require("dnsjit.core.object.dns").new()
local label = require("dnsjit.core.object.dns.label")
local labels = require("dnsjit.core.object.dns.label").new(128)
local q = require("dnsjit.core.object.dns.q").new()

input:open_offline(pcap)
layer:producer(input)
local producer, ctx = layer:produce()

dns.obj_prev = producer(ctx)
dns:parse_header()
dns:parse_q(q, labels, 128)
rfc1035_str = label.torfc1035(dns, labels, 128)
print(rfc1035_str)
