"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReverseSub = exports.Chaining = exports.Ligature = exports.Alternate = exports.Multiple = exports.Single = exports.Table = exports.Tag = exports.LookupType = exports.FeatureParams = void 0;
const prelude_1 = require("@ot-builder/prelude");
const lookup_type_1 = require("./general/lookup-type");
exports.FeatureParams = require("./feature-params");
var lookup_type_2 = require("./general/lookup-type");
Object.defineProperty(exports, "LookupType", { enumerable: true, get: function () { return lookup_type_2.Gsub; } });
// GSUB table definitions
exports.Tag = "GSUB";
class Table {
    constructor(scripts = new Map(), features = [], lookups = [], featureVariations = undefined) {
        this.scripts = scripts;
        this.features = features;
        this.lookups = lookups;
        this.featureVariations = featureVariations;
    }
}
exports.Table = Table;
exports.Single = (0, prelude_1.CaseCreator)(lookup_type_1.Gsub.Single, (0, prelude_1.FallbackPropCreator)(() => ({ mapping: new Map() })));
exports.Multiple = (0, prelude_1.CaseCreator)(lookup_type_1.Gsub.Multi, (0, prelude_1.FallbackPropCreator)(() => ({ mapping: new Map() })));
exports.Alternate = (0, prelude_1.CaseCreator)(lookup_type_1.Gsub.Alternate, (0, prelude_1.FallbackPropCreator)(() => ({ mapping: new Map() })));
exports.Ligature = (0, prelude_1.CaseCreator)(lookup_type_1.Gsub.Ligature, (0, prelude_1.FallbackPropCreator)(() => ({ mapping: [] })));
exports.Chaining = (0, prelude_1.CaseCreator)(lookup_type_1.Gsub.Chaining, (0, prelude_1.FallbackPropCreator)(() => ({ rules: [] })));
exports.ReverseSub = (0, prelude_1.CaseCreator)(lookup_type_1.Gsub.Reverse, (0, prelude_1.FallbackPropCreator)(() => ({ rules: [] })));
//# sourceMappingURL=table-gsub.js.map