import Director from "../core/director";
import { ExportBuildRecipe, ExtBuildContext, GoalMatcher, PreBuildContext, PreBuildResult, Rule } from "../core/interface";
import { RuleBase } from "./rule-base";
type Args = string[];
export declare class OracleRule<T> extends RuleBase<Args> implements Rule<T, Args> {
    private isOracle;
    private FRecipe;
    readonly kindTag = "Mock::OracleRule";
    constructor(isOracle: boolean, matcher: GoalMatcher<Args>, FRecipe: ExportBuildRecipe<T, Args>);
    matchString(id: string): null;
    build(t: ExtBuildContext<T>, ...args: Args): Promise<T>;
    preBuild(t: PreBuildContext<T>): Promise<PreBuildResult.NO | PreBuildResult.YES>;
    shouldTriggerModify(t: PreBuildContext<T>, itselfModified: boolean): Promise<boolean>;
}
export declare function Oracle(dir: Director): {
    oracle: (<T>(pattern: string, FRecipe: ExportBuildRecipe<T, string[]>) => import("../core/interface").Goal<T, string[]>) & {
        glob: <T>(pattern: string, FRecipe: ExportBuildRecipe<T, string[]>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => import("../core/interface").Goal<T, string[]>;
        group: <T>(_subPrefix: string, FRecipe: ExportBuildRecipe<T, string[]>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => import("../core/interface").Goal<T, string[]>;
        make: <T, K extends string[]>(mk: (...args: K) => string, FRecipe: ExportBuildRecipe<T, string[]>) => (...args: K) => import("../core/interface").Goal<T, string[]>;
    };
    computed: (<T>(pattern: string, FRecipe: ExportBuildRecipe<T, string[]>) => import("../core/interface").Goal<T, string[]>) & {
        glob: <T>(pattern: string, FRecipe: ExportBuildRecipe<T, string[]>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => import("../core/interface").Goal<T, string[]>;
        group: <T>(_subPrefix: string, FRecipe: ExportBuildRecipe<T, string[]>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => import("../core/interface").Goal<T, string[]>;
        make: <T, K extends string[]>(mk: (...args: K) => string, FRecipe: ExportBuildRecipe<T, string[]>) => (...args: K) => import("../core/interface").Goal<T, string[]>;
    };
};
export {};
