//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// DomainsClient contains the methods for the Domains group.
// Don't use this type directly, use NewDomainsClient() instead.
type DomainsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDomainsClient creates a new instance of DomainsClient with the specified values.
//   - subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDomainsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DomainsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DomainsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CheckAvailability - Description for Check if a domain is available for registration.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - identifier - Name of the domain.
//   - options - DomainsClientCheckAvailabilityOptions contains the optional parameters for the DomainsClient.CheckAvailability
//     method.
func (client *DomainsClient) CheckAvailability(ctx context.Context, identifier NameIdentifier, options *DomainsClientCheckAvailabilityOptions) (DomainsClientCheckAvailabilityResponse, error) {
	var err error
	const operationName = "DomainsClient.CheckAvailability"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.checkAvailabilityCreateRequest(ctx, identifier, options)
	if err != nil {
		return DomainsClientCheckAvailabilityResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientCheckAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientCheckAvailabilityResponse{}, err
	}
	resp, err := client.checkAvailabilityHandleResponse(httpResp)
	return resp, err
}

// checkAvailabilityCreateRequest creates the CheckAvailability request.
func (client *DomainsClient) checkAvailabilityCreateRequest(ctx context.Context, identifier NameIdentifier, options *DomainsClientCheckAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/checkDomainAvailability"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, identifier); err != nil {
		return nil, err
	}
	return req, nil
}

// checkAvailabilityHandleResponse handles the CheckAvailability response.
func (client *DomainsClient) checkAvailabilityHandleResponse(resp *http.Response) (DomainsClientCheckAvailabilityResponse, error) {
	result := DomainsClientCheckAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainAvailabilityCheckResult); err != nil {
		return DomainsClientCheckAvailabilityResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Description for Creates or updates a domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of the domain.
//   - domain - Domain registration information.
//   - options - DomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainsClient.BeginCreateOrUpdate
//     method.
func (client *DomainsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, domainName string, domain Domain, options *DomainsClientBeginCreateOrUpdateOptions) (*runtime.Poller[DomainsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, domainName, domain, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DomainsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DomainsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Description for Creates or updates a domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *DomainsClient) createOrUpdate(ctx context.Context, resourceGroupName string, domainName string, domain Domain, options *DomainsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "DomainsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, domainName, domain, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *DomainsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, domainName string, domain Domain, options *DomainsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, domain); err != nil {
		return nil, err
	}
	return req, nil
}

// CreateOrUpdateOwnershipIdentifier - Description for Creates an ownership identifier for a domain or updates identifier
// details for an existing identifier
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of domain.
//   - name - Name of identifier.
//   - domainOwnershipIdentifier - A JSON representation of the domain ownership properties.
//   - options - DomainsClientCreateOrUpdateOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.CreateOrUpdateOwnershipIdentifier
//     method.
func (client *DomainsClient) CreateOrUpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientCreateOrUpdateOwnershipIdentifierOptions) (DomainsClientCreateOrUpdateOwnershipIdentifierResponse, error) {
	var err error
	const operationName = "DomainsClient.CreateOrUpdateOwnershipIdentifier"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, domainOwnershipIdentifier, options)
	if err != nil {
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, err
	}
	resp, err := client.createOrUpdateOwnershipIdentifierHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateOwnershipIdentifierCreateRequest creates the CreateOrUpdateOwnershipIdentifier request.
func (client *DomainsClient) createOrUpdateOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientCreateOrUpdateOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, domainOwnershipIdentifier); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateOwnershipIdentifierHandleResponse handles the CreateOrUpdateOwnershipIdentifier response.
func (client *DomainsClient) createOrUpdateOwnershipIdentifierHandleResponse(resp *http.Response) (DomainsClientCreateOrUpdateOwnershipIdentifierResponse, error) {
	result := DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifier); err != nil {
		return DomainsClientCreateOrUpdateOwnershipIdentifierResponse{}, err
	}
	return result, nil
}

// Delete - Description for Delete a domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of the domain.
//   - options - DomainsClientDeleteOptions contains the optional parameters for the DomainsClient.Delete method.
func (client *DomainsClient) Delete(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientDeleteOptions) (DomainsClientDeleteResponse, error) {
	var err error
	const operationName = "DomainsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientDeleteResponse{}, err
	}
	return DomainsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DomainsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.ForceHardDeleteDomain != nil {
		reqQP.Set("forceHardDeleteDomain", strconv.FormatBool(*options.ForceHardDeleteDomain))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteOwnershipIdentifier - Description for Delete ownership identifier for domain
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of domain.
//   - name - Name of identifier.
//   - options - DomainsClientDeleteOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.DeleteOwnershipIdentifier
//     method.
func (client *DomainsClient) DeleteOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientDeleteOwnershipIdentifierOptions) (DomainsClientDeleteOwnershipIdentifierResponse, error) {
	var err error
	const operationName = "DomainsClient.DeleteOwnershipIdentifier"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, options)
	if err != nil {
		return DomainsClientDeleteOwnershipIdentifierResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientDeleteOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientDeleteOwnershipIdentifierResponse{}, err
	}
	return DomainsClientDeleteOwnershipIdentifierResponse{}, nil
}

// deleteOwnershipIdentifierCreateRequest creates the DeleteOwnershipIdentifier request.
func (client *DomainsClient) deleteOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientDeleteOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Description for Get a domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of the domain.
//   - options - DomainsClientGetOptions contains the optional parameters for the DomainsClient.Get method.
func (client *DomainsClient) Get(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientGetOptions) (DomainsClientGetResponse, error) {
	var err error
	const operationName = "DomainsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DomainsClient) getCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DomainsClient) getHandleResponse(resp *http.Response) (DomainsClientGetResponse, error) {
	result := DomainsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Domain); err != nil {
		return DomainsClientGetResponse{}, err
	}
	return result, nil
}

// GetControlCenterSsoRequest - Description for Generate a single sign-on request for the domain management portal.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - options - DomainsClientGetControlCenterSsoRequestOptions contains the optional parameters for the DomainsClient.GetControlCenterSsoRequest
//     method.
func (client *DomainsClient) GetControlCenterSsoRequest(ctx context.Context, options *DomainsClientGetControlCenterSsoRequestOptions) (DomainsClientGetControlCenterSsoRequestResponse, error) {
	var err error
	const operationName = "DomainsClient.GetControlCenterSsoRequest"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getControlCenterSsoRequestCreateRequest(ctx, options)
	if err != nil {
		return DomainsClientGetControlCenterSsoRequestResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientGetControlCenterSsoRequestResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientGetControlCenterSsoRequestResponse{}, err
	}
	resp, err := client.getControlCenterSsoRequestHandleResponse(httpResp)
	return resp, err
}

// getControlCenterSsoRequestCreateRequest creates the GetControlCenterSsoRequest request.
func (client *DomainsClient) getControlCenterSsoRequestCreateRequest(ctx context.Context, options *DomainsClientGetControlCenterSsoRequestOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/generateSsoRequest"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getControlCenterSsoRequestHandleResponse handles the GetControlCenterSsoRequest response.
func (client *DomainsClient) getControlCenterSsoRequestHandleResponse(resp *http.Response) (DomainsClientGetControlCenterSsoRequestResponse, error) {
	result := DomainsClientGetControlCenterSsoRequestResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainControlCenterSsoRequest); err != nil {
		return DomainsClientGetControlCenterSsoRequestResponse{}, err
	}
	return result, nil
}

// GetOwnershipIdentifier - Description for Get ownership identifier for domain
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of domain.
//   - name - Name of identifier.
//   - options - DomainsClientGetOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.GetOwnershipIdentifier
//     method.
func (client *DomainsClient) GetOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientGetOwnershipIdentifierOptions) (DomainsClientGetOwnershipIdentifierResponse, error) {
	var err error
	const operationName = "DomainsClient.GetOwnershipIdentifier"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, options)
	if err != nil {
		return DomainsClientGetOwnershipIdentifierResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientGetOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientGetOwnershipIdentifierResponse{}, err
	}
	resp, err := client.getOwnershipIdentifierHandleResponse(httpResp)
	return resp, err
}

// getOwnershipIdentifierCreateRequest creates the GetOwnershipIdentifier request.
func (client *DomainsClient) getOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, options *DomainsClientGetOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOwnershipIdentifierHandleResponse handles the GetOwnershipIdentifier response.
func (client *DomainsClient) getOwnershipIdentifierHandleResponse(resp *http.Response) (DomainsClientGetOwnershipIdentifierResponse, error) {
	result := DomainsClientGetOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifier); err != nil {
		return DomainsClientGetOwnershipIdentifierResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for Get all domains in a subscription.
//
// Generated from API version 2023-01-01
//   - options - DomainsClientListOptions contains the optional parameters for the DomainsClient.NewListPager method.
func (client *DomainsClient) NewListPager(options *DomainsClientListOptions) *runtime.Pager[DomainsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListResponse]{
		More: func(page DomainsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListResponse) (DomainsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DomainsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return DomainsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *DomainsClient) listCreateRequest(ctx context.Context, options *DomainsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/domains"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *DomainsClient) listHandleResponse(resp *http.Response) (DomainsClientListResponse, error) {
	result := DomainsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainCollection); err != nil {
		return DomainsClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Description for Get all domains in a resource group.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - options - DomainsClientListByResourceGroupOptions contains the optional parameters for the DomainsClient.NewListByResourceGroupPager
//     method.
func (client *DomainsClient) NewListByResourceGroupPager(resourceGroupName string, options *DomainsClientListByResourceGroupOptions) *runtime.Pager[DomainsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListByResourceGroupResponse]{
		More: func(page DomainsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListByResourceGroupResponse) (DomainsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DomainsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return DomainsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *DomainsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *DomainsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *DomainsClient) listByResourceGroupHandleResponse(resp *http.Response) (DomainsClientListByResourceGroupResponse, error) {
	result := DomainsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainCollection); err != nil {
		return DomainsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListOwnershipIdentifiersPager - Description for Lists domain ownership identifiers.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of domain.
//   - options - DomainsClientListOwnershipIdentifiersOptions contains the optional parameters for the DomainsClient.NewListOwnershipIdentifiersPager
//     method.
func (client *DomainsClient) NewListOwnershipIdentifiersPager(resourceGroupName string, domainName string, options *DomainsClientListOwnershipIdentifiersOptions) *runtime.Pager[DomainsClientListOwnershipIdentifiersResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListOwnershipIdentifiersResponse]{
		More: func(page DomainsClientListOwnershipIdentifiersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListOwnershipIdentifiersResponse) (DomainsClientListOwnershipIdentifiersResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DomainsClient.NewListOwnershipIdentifiersPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listOwnershipIdentifiersCreateRequest(ctx, resourceGroupName, domainName, options)
			}, nil)
			if err != nil {
				return DomainsClientListOwnershipIdentifiersResponse{}, err
			}
			return client.listOwnershipIdentifiersHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listOwnershipIdentifiersCreateRequest creates the ListOwnershipIdentifiers request.
func (client *DomainsClient) listOwnershipIdentifiersCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientListOwnershipIdentifiersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOwnershipIdentifiersHandleResponse handles the ListOwnershipIdentifiers response.
func (client *DomainsClient) listOwnershipIdentifiersHandleResponse(resp *http.Response) (DomainsClientListOwnershipIdentifiersResponse, error) {
	result := DomainsClientListOwnershipIdentifiersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifierCollection); err != nil {
		return DomainsClientListOwnershipIdentifiersResponse{}, err
	}
	return result, nil
}

// NewListRecommendationsPager - Description for Get domain name recommendations based on keywords.
//
// Generated from API version 2023-01-01
//   - parameters - Search parameters for domain name recommendations.
//   - options - DomainsClientListRecommendationsOptions contains the optional parameters for the DomainsClient.NewListRecommendationsPager
//     method.
func (client *DomainsClient) NewListRecommendationsPager(parameters DomainRecommendationSearchParameters, options *DomainsClientListRecommendationsOptions) *runtime.Pager[DomainsClientListRecommendationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[DomainsClientListRecommendationsResponse]{
		More: func(page DomainsClientListRecommendationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DomainsClientListRecommendationsResponse) (DomainsClientListRecommendationsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DomainsClient.NewListRecommendationsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listRecommendationsCreateRequest(ctx, parameters, options)
			}, nil)
			if err != nil {
				return DomainsClientListRecommendationsResponse{}, err
			}
			return client.listRecommendationsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listRecommendationsCreateRequest creates the ListRecommendations request.
func (client *DomainsClient) listRecommendationsCreateRequest(ctx context.Context, parameters DomainRecommendationSearchParameters, options *DomainsClientListRecommendationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/listDomainRecommendations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// listRecommendationsHandleResponse handles the ListRecommendations response.
func (client *DomainsClient) listRecommendationsHandleResponse(resp *http.Response) (DomainsClientListRecommendationsResponse, error) {
	result := DomainsClientListRecommendationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NameIdentifierCollection); err != nil {
		return DomainsClientListRecommendationsResponse{}, err
	}
	return result, nil
}

// Renew - Description for Renew a domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of the domain.
//   - options - DomainsClientRenewOptions contains the optional parameters for the DomainsClient.Renew method.
func (client *DomainsClient) Renew(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientRenewOptions) (DomainsClientRenewResponse, error) {
	var err error
	const operationName = "DomainsClient.Renew"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.renewCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientRenewResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientRenewResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientRenewResponse{}, err
	}
	return DomainsClientRenewResponse{}, nil
}

// renewCreateRequest creates the Renew request.
func (client *DomainsClient) renewCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientRenewOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/renew"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// TransferOut - Transfer out domain to another registrar
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of domain.
//   - options - DomainsClientTransferOutOptions contains the optional parameters for the DomainsClient.TransferOut method.
func (client *DomainsClient) TransferOut(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientTransferOutOptions) (DomainsClientTransferOutResponse, error) {
	var err error
	const operationName = "DomainsClient.TransferOut"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.transferOutCreateRequest(ctx, resourceGroupName, domainName, options)
	if err != nil {
		return DomainsClientTransferOutResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientTransferOutResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientTransferOutResponse{}, err
	}
	resp, err := client.transferOutHandleResponse(httpResp)
	return resp, err
}

// transferOutCreateRequest creates the TransferOut request.
func (client *DomainsClient) transferOutCreateRequest(ctx context.Context, resourceGroupName string, domainName string, options *DomainsClientTransferOutOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/transferOut"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// transferOutHandleResponse handles the TransferOut response.
func (client *DomainsClient) transferOutHandleResponse(resp *http.Response) (DomainsClientTransferOutResponse, error) {
	result := DomainsClientTransferOutResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Domain); err != nil {
		return DomainsClientTransferOutResponse{}, err
	}
	return result, nil
}

// Update - Description for Creates or updates a domain.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of the domain.
//   - domain - Domain registration information.
//   - options - DomainsClientUpdateOptions contains the optional parameters for the DomainsClient.Update method.
func (client *DomainsClient) Update(ctx context.Context, resourceGroupName string, domainName string, domain DomainPatchResource, options *DomainsClientUpdateOptions) (DomainsClientUpdateResponse, error) {
	var err error
	const operationName = "DomainsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, domainName, domain, options)
	if err != nil {
		return DomainsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *DomainsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, domainName string, domain DomainPatchResource, options *DomainsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, domain); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *DomainsClient) updateHandleResponse(resp *http.Response) (DomainsClientUpdateResponse, error) {
	result := DomainsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Domain); err != nil {
		return DomainsClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateOwnershipIdentifier - Description for Creates an ownership identifier for a domain or updates identifier details
// for an existing identifier
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - domainName - Name of domain.
//   - name - Name of identifier.
//   - domainOwnershipIdentifier - A JSON representation of the domain ownership properties.
//   - options - DomainsClientUpdateOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.UpdateOwnershipIdentifier
//     method.
func (client *DomainsClient) UpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientUpdateOwnershipIdentifierOptions) (DomainsClientUpdateOwnershipIdentifierResponse, error) {
	var err error
	const operationName = "DomainsClient.UpdateOwnershipIdentifier"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateOwnershipIdentifierCreateRequest(ctx, resourceGroupName, domainName, name, domainOwnershipIdentifier, options)
	if err != nil {
		return DomainsClientUpdateOwnershipIdentifierResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DomainsClientUpdateOwnershipIdentifierResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DomainsClientUpdateOwnershipIdentifierResponse{}, err
	}
	resp, err := client.updateOwnershipIdentifierHandleResponse(httpResp)
	return resp, err
}

// updateOwnershipIdentifierCreateRequest creates the UpdateOwnershipIdentifier request.
func (client *DomainsClient) updateOwnershipIdentifierCreateRequest(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier, options *DomainsClientUpdateOwnershipIdentifierOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, domainOwnershipIdentifier); err != nil {
		return nil, err
	}
	return req, nil
}

// updateOwnershipIdentifierHandleResponse handles the UpdateOwnershipIdentifier response.
func (client *DomainsClient) updateOwnershipIdentifierHandleResponse(resp *http.Response) (DomainsClientUpdateOwnershipIdentifierResponse, error) {
	result := DomainsClientUpdateOwnershipIdentifierResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DomainOwnershipIdentifier); err != nil {
		return DomainsClientUpdateOwnershipIdentifierResponse{}, err
	}
	return result, nil
}
