//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armblueprint.ClientFactory type.
type ServerFactory struct {
	ArtifactsServer            ArtifactsServer
	AssignmentOperationsServer AssignmentOperationsServer
	AssignmentsServer          AssignmentsServer
	BlueprintsServer           BlueprintsServer
	PublishedArtifactsServer   PublishedArtifactsServer
	PublishedBlueprintsServer  PublishedBlueprintsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armblueprint.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armblueprint.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                          *ServerFactory
	trMu                         sync.Mutex
	trArtifactsServer            *ArtifactsServerTransport
	trAssignmentOperationsServer *AssignmentOperationsServerTransport
	trAssignmentsServer          *AssignmentsServerTransport
	trBlueprintsServer           *BlueprintsServerTransport
	trPublishedArtifactsServer   *PublishedArtifactsServerTransport
	trPublishedBlueprintsServer  *PublishedBlueprintsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "ArtifactsClient":
		initServer(s, &s.trArtifactsServer, func() *ArtifactsServerTransport { return NewArtifactsServerTransport(&s.srv.ArtifactsServer) })
		resp, err = s.trArtifactsServer.Do(req)
	case "AssignmentOperationsClient":
		initServer(s, &s.trAssignmentOperationsServer, func() *AssignmentOperationsServerTransport {
			return NewAssignmentOperationsServerTransport(&s.srv.AssignmentOperationsServer)
		})
		resp, err = s.trAssignmentOperationsServer.Do(req)
	case "AssignmentsClient":
		initServer(s, &s.trAssignmentsServer, func() *AssignmentsServerTransport { return NewAssignmentsServerTransport(&s.srv.AssignmentsServer) })
		resp, err = s.trAssignmentsServer.Do(req)
	case "BlueprintsClient":
		initServer(s, &s.trBlueprintsServer, func() *BlueprintsServerTransport { return NewBlueprintsServerTransport(&s.srv.BlueprintsServer) })
		resp, err = s.trBlueprintsServer.Do(req)
	case "PublishedArtifactsClient":
		initServer(s, &s.trPublishedArtifactsServer, func() *PublishedArtifactsServerTransport {
			return NewPublishedArtifactsServerTransport(&s.srv.PublishedArtifactsServer)
		})
		resp, err = s.trPublishedArtifactsServer.Do(req)
	case "PublishedBlueprintsClient":
		initServer(s, &s.trPublishedBlueprintsServer, func() *PublishedBlueprintsServerTransport {
			return NewPublishedBlueprintsServerTransport(&s.srv.PublishedBlueprintsServer)
		})
		resp, err = s.trPublishedBlueprintsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
