//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdelegatednetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/delegatednetwork/armdelegatednetwork"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/delegatedNetworkOperationsList.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armdelegatednetwork.OperationListResult{
		// 	Value: []*armdelegatednetwork.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/controller/write"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Create or update a Controller Service instance."),
		// 				Operation: to.Ptr("Create or update a Controller Service instance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated Network Controller Service instance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/controller/read"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Get a Controller Service instance."),
		// 				Operation: to.Ptr("Get a Controller Service instance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated Network Controller Service instance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/controller/delete"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Delete a Controller Service instance."),
		// 				Operation: to.Ptr("Delete a Controller Service instance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated Network Controller Service instance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/orchestratorInstances/write"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Create or update a orchestratorInstance."),
		// 				Operation: to.Ptr("Create or update a orchestratorInstance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated Network orchestratorInstance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/controller/read"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Get a orchestratorInstance."),
		// 				Operation: to.Ptr("Get a orchestratorInstances."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated Network orchestratorInstance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/controller/delete"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Delete a orchestratorInstance."),
		// 				Operation: to.Ptr("Delete a orchestratorInstance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated Network orchestratorInstance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets/write"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Create or update a Delegated subnet instance."),
		// 				Operation: to.Ptr("Create or update a Delegated subnet instance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated subnet instance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets/read"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Get a Delegated subnet instance."),
		// 				Operation: to.Ptr("Get a Delegated subnet instance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Service"),
		// 				Resource: to.Ptr("Microsoft Delegated subnet instance"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DelegatedNetwork/delegatedSubnets/delete"),
		// 			Display: &armdelegatednetwork.OperationDisplay{
		// 				Description: to.Ptr("Delete a Delegated subnet instance."),
		// 				Operation: to.Ptr("Delete a Delegated subnet instance."),
		// 				Provider: to.Ptr("Microsoft Delegated Network Controller Service"),
		// 				Resource: to.Ptr("Microsoft Delegated subnet instance"),
		// 			},
		// 	}},
		// }
	}
}
