//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagednetworkfabric

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// NetworkDeviceSKUsClient contains the methods for the NetworkDeviceSKUs group.
// Don't use this type directly, use NewNetworkDeviceSKUsClient() instead.
type NetworkDeviceSKUsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewNetworkDeviceSKUsClient creates a new instance of NetworkDeviceSKUsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewNetworkDeviceSKUsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*NetworkDeviceSKUsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &NetworkDeviceSKUsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Get a Network Device SKU details.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - networkDeviceSKUName - Name of the Network Device SKU.
//   - options - NetworkDeviceSKUsClientGetOptions contains the optional parameters for the NetworkDeviceSKUsClient.Get method.
func (client *NetworkDeviceSKUsClient) Get(ctx context.Context, networkDeviceSKUName string, options *NetworkDeviceSKUsClientGetOptions) (NetworkDeviceSKUsClientGetResponse, error) {
	var err error
	const operationName = "NetworkDeviceSKUsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, networkDeviceSKUName, options)
	if err != nil {
		return NetworkDeviceSKUsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return NetworkDeviceSKUsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return NetworkDeviceSKUsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *NetworkDeviceSKUsClient) getCreateRequest(ctx context.Context, networkDeviceSKUName string, options *NetworkDeviceSKUsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ManagedNetworkFabric/networkDeviceSkus/{networkDeviceSkuName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if networkDeviceSKUName == "" {
		return nil, errors.New("parameter networkDeviceSKUName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkDeviceSkuName}", url.PathEscape(networkDeviceSKUName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *NetworkDeviceSKUsClient) getHandleResponse(resp *http.Response) (NetworkDeviceSKUsClientGetResponse, error) {
	result := NetworkDeviceSKUsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkDeviceSKU); err != nil {
		return NetworkDeviceSKUsClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List Network Device SKUs for the given subscription.
//
// Generated from API version 2023-06-15
//   - options - NetworkDeviceSKUsClientListBySubscriptionOptions contains the optional parameters for the NetworkDeviceSKUsClient.NewListBySubscriptionPager
//     method.
func (client *NetworkDeviceSKUsClient) NewListBySubscriptionPager(options *NetworkDeviceSKUsClientListBySubscriptionOptions) *runtime.Pager[NetworkDeviceSKUsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[NetworkDeviceSKUsClientListBySubscriptionResponse]{
		More: func(page NetworkDeviceSKUsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *NetworkDeviceSKUsClientListBySubscriptionResponse) (NetworkDeviceSKUsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "NetworkDeviceSKUsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return NetworkDeviceSKUsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *NetworkDeviceSKUsClient) listBySubscriptionCreateRequest(ctx context.Context, options *NetworkDeviceSKUsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ManagedNetworkFabric/networkDeviceSkus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *NetworkDeviceSKUsClient) listBySubscriptionHandleResponse(resp *http.Response) (NetworkDeviceSKUsClientListBySubscriptionResponse, error) {
	result := NetworkDeviceSKUsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkDeviceSKUsListResult); err != nil {
		return NetworkDeviceSKUsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}
