//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managementgroups/armmanagementgroups"
	"net/http"
)

// APIServer is a fake server for instances of the armmanagementgroups.APIClient type.
type APIServer struct {
	// CheckNameAvailability is the fake for method APIClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, checkNameAvailabilityRequest armmanagementgroups.CheckNameAvailabilityRequest, options *armmanagementgroups.APIClientCheckNameAvailabilityOptions) (resp azfake.Responder[armmanagementgroups.APIClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// StartTenantBackfill is the fake for method APIClient.StartTenantBackfill
	// HTTP status codes to indicate success: http.StatusOK
	StartTenantBackfill func(ctx context.Context, options *armmanagementgroups.APIClientStartTenantBackfillOptions) (resp azfake.Responder[armmanagementgroups.APIClientStartTenantBackfillResponse], errResp azfake.ErrorResponder)

	// TenantBackfillStatus is the fake for method APIClient.TenantBackfillStatus
	// HTTP status codes to indicate success: http.StatusOK
	TenantBackfillStatus func(ctx context.Context, options *armmanagementgroups.APIClientTenantBackfillStatusOptions) (resp azfake.Responder[armmanagementgroups.APIClientTenantBackfillStatusResponse], errResp azfake.ErrorResponder)
}

// NewAPIServerTransport creates a new instance of APIServerTransport with the provided implementation.
// The returned APIServerTransport instance is connected to an instance of armmanagementgroups.APIClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAPIServerTransport(srv *APIServer) *APIServerTransport {
	return &APIServerTransport{srv: srv}
}

// APIServerTransport connects instances of armmanagementgroups.APIClient to instances of APIServer.
// Don't use this type directly, use NewAPIServerTransport instead.
type APIServerTransport struct {
	srv *APIServer
}

// Do implements the policy.Transporter interface for APIServerTransport.
func (a *APIServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "APIClient.CheckNameAvailability":
		resp, err = a.dispatchCheckNameAvailability(req)
	case "APIClient.StartTenantBackfill":
		resp, err = a.dispatchStartTenantBackfill(req)
	case "APIClient.TenantBackfillStatus":
		resp, err = a.dispatchTenantBackfillStatus(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *APIServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if a.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagementgroups.CheckNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CheckNameAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *APIServerTransport) dispatchStartTenantBackfill(req *http.Request) (*http.Response, error) {
	if a.srv.StartTenantBackfill == nil {
		return nil, &nonRetriableError{errors.New("fake for method StartTenantBackfill not implemented")}
	}
	respr, errRespr := a.srv.StartTenantBackfill(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantBackfillStatusResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *APIServerTransport) dispatchTenantBackfillStatus(req *http.Request) (*http.Response, error) {
	if a.srv.TenantBackfillStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method TenantBackfillStatus not implemented")}
	}
	respr, errRespr := a.srv.TenantBackfillStatus(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantBackfillStatusResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
