//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAPICollectionClient creates a new instance of APICollectionClient.
func (c *ClientFactory) NewAPICollectionClient() *APICollectionClient {
	subClient, _ := NewAPICollectionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAPICollectionOffboardingClient creates a new instance of APICollectionOffboardingClient.
func (c *ClientFactory) NewAPICollectionOffboardingClient() *APICollectionOffboardingClient {
	subClient, _ := NewAPICollectionOffboardingClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAPICollectionOnboardingClient creates a new instance of APICollectionOnboardingClient.
func (c *ClientFactory) NewAPICollectionOnboardingClient() *APICollectionOnboardingClient {
	subClient, _ := NewAPICollectionOnboardingClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAccountConnectorsClient creates a new instance of AccountConnectorsClient.
func (c *ClientFactory) NewAccountConnectorsClient() *AccountConnectorsClient {
	subClient, _ := NewAccountConnectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAdaptiveApplicationControlsClient creates a new instance of AdaptiveApplicationControlsClient.
func (c *ClientFactory) NewAdaptiveApplicationControlsClient() *AdaptiveApplicationControlsClient {
	subClient, _ := NewAdaptiveApplicationControlsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAdaptiveNetworkHardeningsClient creates a new instance of AdaptiveNetworkHardeningsClient.
func (c *ClientFactory) NewAdaptiveNetworkHardeningsClient() *AdaptiveNetworkHardeningsClient {
	subClient, _ := NewAdaptiveNetworkHardeningsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAdvancedThreatProtectionClient creates a new instance of AdvancedThreatProtectionClient.
func (c *ClientFactory) NewAdvancedThreatProtectionClient() *AdvancedThreatProtectionClient {
	subClient, _ := NewAdvancedThreatProtectionClient(c.credential, c.options)
	return subClient
}

// NewAlertsClient creates a new instance of AlertsClient.
func (c *ClientFactory) NewAlertsClient() *AlertsClient {
	subClient, _ := NewAlertsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAlertsSuppressionRulesClient creates a new instance of AlertsSuppressionRulesClient.
func (c *ClientFactory) NewAlertsSuppressionRulesClient() *AlertsSuppressionRulesClient {
	subClient, _ := NewAlertsSuppressionRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAllowedConnectionsClient creates a new instance of AllowedConnectionsClient.
func (c *ClientFactory) NewAllowedConnectionsClient() *AllowedConnectionsClient {
	subClient, _ := NewAllowedConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewApplicationClient creates a new instance of ApplicationClient.
func (c *ClientFactory) NewApplicationClient() *ApplicationClient {
	subClient, _ := NewApplicationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewApplicationsClient creates a new instance of ApplicationsClient.
func (c *ClientFactory) NewApplicationsClient() *ApplicationsClient {
	subClient, _ := NewApplicationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAssessmentsClient creates a new instance of AssessmentsClient.
func (c *ClientFactory) NewAssessmentsClient() *AssessmentsClient {
	subClient, _ := NewAssessmentsClient(c.credential, c.options)
	return subClient
}

// NewAssessmentsMetadataClient creates a new instance of AssessmentsMetadataClient.
func (c *ClientFactory) NewAssessmentsMetadataClient() *AssessmentsMetadataClient {
	subClient, _ := NewAssessmentsMetadataClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAutoProvisioningSettingsClient creates a new instance of AutoProvisioningSettingsClient.
func (c *ClientFactory) NewAutoProvisioningSettingsClient() *AutoProvisioningSettingsClient {
	subClient, _ := NewAutoProvisioningSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAutomationsClient creates a new instance of AutomationsClient.
func (c *ClientFactory) NewAutomationsClient() *AutomationsClient {
	subClient, _ := NewAutomationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCenterClient creates a new instance of CenterClient.
func (c *ClientFactory) NewCenterClient() *CenterClient {
	subClient, _ := NewCenterClient(c.credential, c.options)
	return subClient
}

// NewComplianceResultsClient creates a new instance of ComplianceResultsClient.
func (c *ClientFactory) NewComplianceResultsClient() *ComplianceResultsClient {
	subClient, _ := NewComplianceResultsClient(c.credential, c.options)
	return subClient
}

// NewCompliancesClient creates a new instance of CompliancesClient.
func (c *ClientFactory) NewCompliancesClient() *CompliancesClient {
	subClient, _ := NewCompliancesClient(c.credential, c.options)
	return subClient
}

// NewConnectorApplicationClient creates a new instance of ConnectorApplicationClient.
func (c *ClientFactory) NewConnectorApplicationClient() *ConnectorApplicationClient {
	subClient, _ := NewConnectorApplicationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConnectorApplicationsClient creates a new instance of ConnectorApplicationsClient.
func (c *ClientFactory) NewConnectorApplicationsClient() *ConnectorApplicationsClient {
	subClient, _ := NewConnectorApplicationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConnectorsClient creates a new instance of ConnectorsClient.
func (c *ClientFactory) NewConnectorsClient() *ConnectorsClient {
	subClient, _ := NewConnectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewContactsClient creates a new instance of ContactsClient.
func (c *ClientFactory) NewContactsClient() *ContactsClient {
	subClient, _ := NewContactsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCustomAssessmentAutomationsClient creates a new instance of CustomAssessmentAutomationsClient.
func (c *ClientFactory) NewCustomAssessmentAutomationsClient() *CustomAssessmentAutomationsClient {
	subClient, _ := NewCustomAssessmentAutomationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCustomEntityStoreAssignmentsClient creates a new instance of CustomEntityStoreAssignmentsClient.
func (c *ClientFactory) NewCustomEntityStoreAssignmentsClient() *CustomEntityStoreAssignmentsClient {
	subClient, _ := NewCustomEntityStoreAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDeviceSecurityGroupsClient creates a new instance of DeviceSecurityGroupsClient.
func (c *ClientFactory) NewDeviceSecurityGroupsClient() *DeviceSecurityGroupsClient {
	subClient, _ := NewDeviceSecurityGroupsClient(c.credential, c.options)
	return subClient
}

// NewDiscoveredSecuritySolutionsClient creates a new instance of DiscoveredSecuritySolutionsClient.
func (c *ClientFactory) NewDiscoveredSecuritySolutionsClient() *DiscoveredSecuritySolutionsClient {
	subClient, _ := NewDiscoveredSecuritySolutionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExternalSecuritySolutionsClient creates a new instance of ExternalSecuritySolutionsClient.
func (c *ClientFactory) NewExternalSecuritySolutionsClient() *ExternalSecuritySolutionsClient {
	subClient, _ := NewExternalSecuritySolutionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGovernanceAssignmentsClient creates a new instance of GovernanceAssignmentsClient.
func (c *ClientFactory) NewGovernanceAssignmentsClient() *GovernanceAssignmentsClient {
	subClient, _ := NewGovernanceAssignmentsClient(c.credential, c.options)
	return subClient
}

// NewGovernanceRulesClient creates a new instance of GovernanceRulesClient.
func (c *ClientFactory) NewGovernanceRulesClient() *GovernanceRulesClient {
	subClient, _ := NewGovernanceRulesClient(c.credential, c.options)
	return subClient
}

// NewHealthReportClient creates a new instance of HealthReportClient.
func (c *ClientFactory) NewHealthReportClient() *HealthReportClient {
	subClient, _ := NewHealthReportClient(c.credential, c.options)
	return subClient
}

// NewHealthReportsClient creates a new instance of HealthReportsClient.
func (c *ClientFactory) NewHealthReportsClient() *HealthReportsClient {
	subClient, _ := NewHealthReportsClient(c.credential, c.options)
	return subClient
}

// NewInformationProtectionPoliciesClient creates a new instance of InformationProtectionPoliciesClient.
func (c *ClientFactory) NewInformationProtectionPoliciesClient() *InformationProtectionPoliciesClient {
	subClient, _ := NewInformationProtectionPoliciesClient(c.credential, c.options)
	return subClient
}

// NewIngestionSettingsClient creates a new instance of IngestionSettingsClient.
func (c *ClientFactory) NewIngestionSettingsClient() *IngestionSettingsClient {
	subClient, _ := NewIngestionSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIotSecuritySolutionAnalyticsClient creates a new instance of IotSecuritySolutionAnalyticsClient.
func (c *ClientFactory) NewIotSecuritySolutionAnalyticsClient() *IotSecuritySolutionAnalyticsClient {
	subClient, _ := NewIotSecuritySolutionAnalyticsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIotSecuritySolutionClient creates a new instance of IotSecuritySolutionClient.
func (c *ClientFactory) NewIotSecuritySolutionClient() *IotSecuritySolutionClient {
	subClient, _ := NewIotSecuritySolutionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIotSecuritySolutionsAnalyticsAggregatedAlertClient creates a new instance of IotSecuritySolutionsAnalyticsAggregatedAlertClient.
func (c *ClientFactory) NewIotSecuritySolutionsAnalyticsAggregatedAlertClient() *IotSecuritySolutionsAnalyticsAggregatedAlertClient {
	subClient, _ := NewIotSecuritySolutionsAnalyticsAggregatedAlertClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIotSecuritySolutionsAnalyticsRecommendationClient creates a new instance of IotSecuritySolutionsAnalyticsRecommendationClient.
func (c *ClientFactory) NewIotSecuritySolutionsAnalyticsRecommendationClient() *IotSecuritySolutionsAnalyticsRecommendationClient {
	subClient, _ := NewIotSecuritySolutionsAnalyticsRecommendationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJitNetworkAccessPoliciesClient creates a new instance of JitNetworkAccessPoliciesClient.
func (c *ClientFactory) NewJitNetworkAccessPoliciesClient() *JitNetworkAccessPoliciesClient {
	subClient, _ := NewJitNetworkAccessPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocationsClient creates a new instance of LocationsClient.
func (c *ClientFactory) NewLocationsClient() *LocationsClient {
	subClient, _ := NewLocationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMdeOnboardingsClient creates a new instance of MdeOnboardingsClient.
func (c *ClientFactory) NewMdeOnboardingsClient() *MdeOnboardingsClient {
	subClient, _ := NewMdeOnboardingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewOperatorsClient creates a new instance of OperatorsClient.
func (c *ClientFactory) NewOperatorsClient() *OperatorsClient {
	subClient, _ := NewOperatorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPricingsClient creates a new instance of PricingsClient.
func (c *ClientFactory) NewPricingsClient() *PricingsClient {
	subClient, _ := NewPricingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRegulatoryComplianceAssessmentsClient creates a new instance of RegulatoryComplianceAssessmentsClient.
func (c *ClientFactory) NewRegulatoryComplianceAssessmentsClient() *RegulatoryComplianceAssessmentsClient {
	subClient, _ := NewRegulatoryComplianceAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRegulatoryComplianceControlsClient creates a new instance of RegulatoryComplianceControlsClient.
func (c *ClientFactory) NewRegulatoryComplianceControlsClient() *RegulatoryComplianceControlsClient {
	subClient, _ := NewRegulatoryComplianceControlsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRegulatoryComplianceStandardsClient creates a new instance of RegulatoryComplianceStandardsClient.
func (c *ClientFactory) NewRegulatoryComplianceStandardsClient() *RegulatoryComplianceStandardsClient {
	subClient, _ := NewRegulatoryComplianceStandardsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLVulnerabilityAssessmentBaselineRulesClient creates a new instance of SQLVulnerabilityAssessmentBaselineRulesClient.
func (c *ClientFactory) NewSQLVulnerabilityAssessmentBaselineRulesClient() *SQLVulnerabilityAssessmentBaselineRulesClient {
	subClient, _ := NewSQLVulnerabilityAssessmentBaselineRulesClient(c.credential, c.options)
	return subClient
}

// NewSQLVulnerabilityAssessmentScanResultsClient creates a new instance of SQLVulnerabilityAssessmentScanResultsClient.
func (c *ClientFactory) NewSQLVulnerabilityAssessmentScanResultsClient() *SQLVulnerabilityAssessmentScanResultsClient {
	subClient, _ := NewSQLVulnerabilityAssessmentScanResultsClient(c.credential, c.options)
	return subClient
}

// NewSQLVulnerabilityAssessmentScansClient creates a new instance of SQLVulnerabilityAssessmentScansClient.
func (c *ClientFactory) NewSQLVulnerabilityAssessmentScansClient() *SQLVulnerabilityAssessmentScansClient {
	subClient, _ := NewSQLVulnerabilityAssessmentScansClient(c.credential, c.options)
	return subClient
}

// NewSecureScoreControlDefinitionsClient creates a new instance of SecureScoreControlDefinitionsClient.
func (c *ClientFactory) NewSecureScoreControlDefinitionsClient() *SecureScoreControlDefinitionsClient {
	subClient, _ := NewSecureScoreControlDefinitionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSecureScoreControlsClient creates a new instance of SecureScoreControlsClient.
func (c *ClientFactory) NewSecureScoreControlsClient() *SecureScoreControlsClient {
	subClient, _ := NewSecureScoreControlsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSecureScoresClient creates a new instance of SecureScoresClient.
func (c *ClientFactory) NewSecureScoresClient() *SecureScoresClient {
	subClient, _ := NewSecureScoresClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSensitivitySettingsClient creates a new instance of SensitivitySettingsClient.
func (c *ClientFactory) NewSensitivitySettingsClient() *SensitivitySettingsClient {
	subClient, _ := NewSensitivitySettingsClient(c.credential, c.options)
	return subClient
}

// NewServerVulnerabilityAssessmentClient creates a new instance of ServerVulnerabilityAssessmentClient.
func (c *ClientFactory) NewServerVulnerabilityAssessmentClient() *ServerVulnerabilityAssessmentClient {
	subClient, _ := NewServerVulnerabilityAssessmentClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSettingsClient creates a new instance of SettingsClient.
func (c *ClientFactory) NewSettingsClient() *SettingsClient {
	subClient, _ := NewSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSoftwareInventoriesClient creates a new instance of SoftwareInventoriesClient.
func (c *ClientFactory) NewSoftwareInventoriesClient() *SoftwareInventoriesClient {
	subClient, _ := NewSoftwareInventoriesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSolutionsClient creates a new instance of SolutionsClient.
func (c *ClientFactory) NewSolutionsClient() *SolutionsClient {
	subClient, _ := NewSolutionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSolutionsReferenceDataClient creates a new instance of SolutionsReferenceDataClient.
func (c *ClientFactory) NewSolutionsReferenceDataClient() *SolutionsReferenceDataClient {
	subClient, _ := NewSolutionsReferenceDataClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSubAssessmentsClient creates a new instance of SubAssessmentsClient.
func (c *ClientFactory) NewSubAssessmentsClient() *SubAssessmentsClient {
	subClient, _ := NewSubAssessmentsClient(c.credential, c.options)
	return subClient
}

// NewTasksClient creates a new instance of TasksClient.
func (c *ClientFactory) NewTasksClient() *TasksClient {
	subClient, _ := NewTasksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTopologyClient creates a new instance of TopologyClient.
func (c *ClientFactory) NewTopologyClient() *TopologyClient {
	subClient, _ := NewTopologyClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceSettingsClient creates a new instance of WorkspaceSettingsClient.
func (c *ClientFactory) NewWorkspaceSettingsClient() *WorkspaceSettingsClient {
	subClient, _ := NewWorkspaceSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
