//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// PricingsServer is a fake server for instances of the armsecurity.PricingsClient type.
type PricingsServer struct {
	// Get is the fake for method PricingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, pricingName string, options *armsecurity.PricingsClientGetOptions) (resp azfake.Responder[armsecurity.PricingsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method PricingsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armsecurity.PricingsClientListOptions) (resp azfake.Responder[armsecurity.PricingsClientListResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method PricingsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, pricingName string, pricing armsecurity.Pricing, options *armsecurity.PricingsClientUpdateOptions) (resp azfake.Responder[armsecurity.PricingsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewPricingsServerTransport creates a new instance of PricingsServerTransport with the provided implementation.
// The returned PricingsServerTransport instance is connected to an instance of armsecurity.PricingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPricingsServerTransport(srv *PricingsServer) *PricingsServerTransport {
	return &PricingsServerTransport{srv: srv}
}

// PricingsServerTransport connects instances of armsecurity.PricingsClient to instances of PricingsServer.
// Don't use this type directly, use NewPricingsServerTransport instead.
type PricingsServerTransport struct {
	srv *PricingsServer
}

// Do implements the policy.Transporter interface for PricingsServerTransport.
func (p *PricingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PricingsClient.Get":
		resp, err = p.dispatchGet(req)
	case "PricingsClient.List":
		resp, err = p.dispatchList(req)
	case "PricingsClient.Update":
		resp, err = p.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PricingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/pricings/(?P<pricingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	pricingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pricingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), pricingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Pricing, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PricingsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if p.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/pricings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := p.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PricingList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PricingsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/pricings/(?P<pricingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.Pricing](req)
	if err != nil {
		return nil, err
	}
	pricingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pricingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Update(req.Context(), pricingNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Pricing, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
