// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtM3DC1Options.C                              //
// ************************************************************************* //

#include <avtM3DC1Options.h>

#include <DBOptionsAttributes.h>

#include <vector>
#include <string>

// ****************************************************************************
//  Function: GetM3DC1ReadOptions
//
//  Purpose:
//      Creates the options for M3DC1 readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Fri Dec 4 15:04:15 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetM3DC1ReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

//    rv->SetInt("Number of poloidal planes", 1);

    rv->SetEnum("Mesh refinement", 1);
    std::vector<std::string> refinement;
    refinement.push_back("1");
    refinement.push_back("2");
    refinement.push_back("3");
    refinement.push_back("4");
    refinement.push_back("5");
    refinement.push_back("6");
    refinement.push_back("7");
    refinement.push_back("8");
    refinement.push_back("9");
    refinement.push_back("10");
//    refinement.push_back("Variable");
    rv->SetEnumStrings("Mesh refinement", refinement);

    rv->SetEnum("Linear mesh data location", 0);
    std::vector<std::string> centering;
    centering.push_back("Node");
    centering.push_back("Element");
    rv->SetEnumStrings("Linear mesh data location", centering);
 
    rv->SetBool("Process Data Selections in the Reader", false);

    return rv;
}


// ****************************************************************************
//  Function: GetM3DC1WriteOptions
//
//  Purpose:
//      Creates the options for M3DC1 writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Fri Dec 4 15:04:15 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetM3DC1WriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
