title: Release Notes for v2.2

Python-Markdown 2.2 Release Notes
=================================

We are pleased to release Python-Markdown 2.2 which makes improvements on 2.1.
While 2.2 is primarily a bug fix release, some internal improvements were made
to the parser, and a few security issues were resolved.

Python-Markdown supports Python versions 2.5, 2.6, 2.7, 3.1, and 3.2 out
of the box.

Backwards-incompatible Changes
------------------------------

While Python-Markdown has received only minor internal changes since the last
release, there are a few backward-incompatible changes to note:

* Support had been dropped for Python 2.4. No guarantees are made that the
  library will work in any version of Python lower than 2.5. Additionally, while
  the library had been tested with Python 2.5, consider Python 2.5 support to be
  depreciated. It is not likely that any future versions will continue to
  support any version of Python less than 2.6.

* For many years Python-Markdown has identified `<ins>` and `<del>` tags in raw
  HTML input as block level tags. As they are actually inline level tags, this
  behavior has been changed. This may result in slightly different output. While
  in most cases, the new output is more correct, there may be a few edge cases
  where a document author has relied on the previous incorrect behavior. It is
  likely that a few adjustments may need to be made to those documents.

* The behavior of the `enable_attributes` keyword has been slightly altered. If
  authors have been using attributes in documents with `safe_mode` on, those
  attributes will no longer be parsed unless `enable_attributes` is explicitly
  set to `True`. This change was made to prevent untrusted authors from
  injecting potentially harmful JavaScript in documents. This change had no
  effect when not in `safe_mode`.

What's New in Python-Markdown 2.2
---------------------------------

The docs were refactored and can now be found at
`http://packages.python.org/Markdown/`. The docs are now maintained in the
Repository and are generated by the `setup.py build_docs` command.

The [Sane_Lists](../extensions/sane_lists.md)
extension was added. The Sane Lists Extension alters the behavior of the
Markdown List syntax to be less surprising by not allowing the mixing of list
types. In other words, an ordered list will not continue when an unordered list
item is encountered and vice versa.

Markdown now excepts a full path to an extension module. In other words, your
extensions no longer need to be in the primary namespace (and start with `mdx_`)
for Markdown to find them. Just do `Markdown(extension=['path.to.some.module'])`.
As long as the provided module contains a compatible extension, the extension
will be loaded.

The BlockParser API was slightly altered to allow `blockprocessor.run` to return
`True` or `False` which provides more control to the block processor loop from
within any Blockprocessor instance.

Various bug fixes have been made. See the
[commit log](https://github.com/Python-Markdown/markdown/commits/master)
for a complete history of the changes.
