
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <math_Matrix.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BSplCLib.hxx>
#include <BSplCLib_Cache.hxx>
#include <BSplCLib_CacheParams.hxx>
#include <BSplCLib_EvaluatorFunction.hxx>
#include <BSplCLib_KnotDistribution.hxx>
#include <BSplCLib_MultDistribution.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BSplCLib(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BSplCLib"));
py::object klass;

//Python trampoline classes
    class Py_BSplCLib_EvaluatorFunction : public BSplCLib_EvaluatorFunction{
    public:
        using BSplCLib_EvaluatorFunction::BSplCLib_EvaluatorFunction;


        // public pure virtual
        void Evaluate( const Standard_Integer theDerivativeRequest, const Standard_Real * theStartEnd, const Standard_Real theParameter,Standard_Real & theResult,Standard_Integer & theErrorCode) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,BSplCLib_EvaluatorFunction,Evaluate,theDerivativeRequest,theStartEnd,theParameter,theResult,theErrorCode) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class BSplCLib from ./opencascade/BSplCLib.hxx
    klass = m.attr("BSplCLib");

    // default constructor
    register_default_constructor<BSplCLib , shared_ptr<BSplCLib>>(m,"BSplCLib");

    // nested enums

    static_cast<py::class_<BSplCLib , shared_ptr<BSplCLib>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("FirstUKnotIndex_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger &  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger &  ) >(&BSplCLib::FirstUKnotIndex),
                    R"#(Computes the index of the knots value which gives the start point of the curve.)#"  , py::arg("Degree"),  py::arg("Mults")
          )
        .def_static("LastUKnotIndex_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger &  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger &  ) >(&BSplCLib::LastUKnotIndex),
                    R"#(Computes the index of the knots value which gives the end point of the curve.)#"  , py::arg("Degree"),  py::arg("Mults")
          )
        .def_static("FlatIndex_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const Standard_Boolean  ) >(&BSplCLib::FlatIndex),
                    R"#(Computes the index of the flats knots sequence corresponding to <Index> in the knots sequence which multiplicities are <Mults>.)#"  , py::arg("Degree"),  py::arg("Index"),  py::arg("Mults"),  py::arg("Periodic")
          )
        .def_static("MaxKnotMult_s",
                    (Standard_Integer (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<Standard_Integer (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Integer  ) >(&BSplCLib::MaxKnotMult),
                    R"#(Finds the greatest multiplicity in a set of knots between K1 and K2. Mults is the multiplicity associated with each knot value.)#"  , py::arg("Mults"),  py::arg("K1"),  py::arg("K2")
          )
        .def_static("MinKnotMult_s",
                    (Standard_Integer (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<Standard_Integer (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Integer  ) >(&BSplCLib::MinKnotMult),
                    R"#(Finds the lowest multiplicity in a set of knots between K1 and K2. Mults is the multiplicity associated with each knot value.)#"  , py::arg("Mults"),  py::arg("K1"),  py::arg("K2")
          )
        .def_static("NbPoles_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfInteger &  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfInteger &  ) >(&BSplCLib::NbPoles),
                    R"#(Returns the number of poles of the curve. Returns 0 if one of the multiplicities is incorrect.)#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Mults")
          )
        .def_static("KnotSequenceLength_s",
                    (Standard_Integer (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Boolean  ) >(&BSplCLib::KnotSequenceLength),
                    R"#(Returns the length of the sequence of knots with repetition.)#"  , py::arg("Mults"),  py::arg("Degree"),  py::arg("Periodic")
          )
        .def_static("KnotSequence_s",
                    (void (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,   const Standard_Boolean  ) ) static_cast<void (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,   const Standard_Boolean  ) >(&BSplCLib::KnotSequence),
                    R"#()#"  , py::arg("Knots"),  py::arg("Mults"),  py::arg("KnotSeq"),  py::arg("Periodic")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("KnotSequence_s",
                    (void (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Boolean ,  TColStd_Array1OfReal &  ) ) static_cast<void (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Boolean ,  TColStd_Array1OfReal &  ) >(&BSplCLib::KnotSequence),
                    R"#(Computes the sequence of knots KnotSeq with repetition of the knots of multiplicity greater than 1.)#"  , py::arg("Knots"),  py::arg("Mults"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("KnotSeq")
          )
        .def_static("KnotsLength_s",
                    (Standard_Integer (*)(  const TColStd_Array1OfReal & ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)(  const TColStd_Array1OfReal & ,   const Standard_Boolean  ) >(&BSplCLib::KnotsLength),
                    R"#(Returns the length of the sequence of knots (and Mults) without repetition.)#"  , py::arg("KnotSeq"),  py::arg("Periodic")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("Knots_s",
                    (void (*)(  const TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Boolean  ) ) static_cast<void (*)(  const TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Boolean  ) >(&BSplCLib::Knots),
                    R"#(Computes the sequence of knots Knots without repetition of the knots of multiplicity greater than 1.)#"  , py::arg("KnotSeq"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("Periodic")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("KnotForm_s",
                    (BSplCLib_KnotDistribution (*)(  const TColStd_Array1OfReal & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<BSplCLib_KnotDistribution (*)(  const TColStd_Array1OfReal & ,   const Standard_Integer ,   const Standard_Integer  ) >(&BSplCLib::KnotForm),
                    R"#(Analyses if the knots distribution is "Uniform" or "NonUniform" between the knot FromK1 and the knot ToK2. There is no repetition of knot in the knots'sequence <Knots>.)#"  , py::arg("Knots"),  py::arg("FromK1"),  py::arg("ToK2")
          )
        .def_static("MultForm_s",
                    (BSplCLib_MultDistribution (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<BSplCLib_MultDistribution (*)(  const TColStd_Array1OfInteger & ,   const Standard_Integer ,   const Standard_Integer  ) >(&BSplCLib::MultForm),
                    R"#(Analyses the distribution of multiplicities between the knot FromK1 and the Knot ToK2.)#"  , py::arg("Mults"),  py::arg("FromK1"),  py::arg("ToK2")
          )
        .def_static("Reparametrize_s",
                    (void (*)(  const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal &  ) >(&BSplCLib::Reparametrize),
                    R"#(Reparametrizes a B-spline curve to [U1, U2]. The knot values are recomputed such that Knots (Lower) = U1 and Knots (Upper) = U2 but the knot form is not modified. Warnings : In the array Knots the values must be in ascending order. U1 must not be equal to U2 to avoid division by zero.)#"  , py::arg("U1"),  py::arg("U2"),  py::arg("Knots")
          )
        .def_static("Reverse_s",
                    (void (*)( TColStd_Array1OfReal &  ) ) static_cast<void (*)( TColStd_Array1OfReal &  ) >(&BSplCLib::Reverse),
                    R"#(Reverses the array knots to become the knots sequence of the reversed curve.)#"  , py::arg("Knots")
          )
        .def_static("Reverse_s",
                    (void (*)( TColStd_Array1OfInteger &  ) ) static_cast<void (*)( TColStd_Array1OfInteger &  ) >(&BSplCLib::Reverse),
                    R"#(Reverses the array of multiplicities.)#"  , py::arg("Mults")
          )
        .def_static("Reverse_s",
                    (void (*)( TColgp_Array1OfPnt & ,   const Standard_Integer  ) ) static_cast<void (*)( TColgp_Array1OfPnt & ,   const Standard_Integer  ) >(&BSplCLib::Reverse),
                    R"#(Reverses the array of poles. Last is the index of the new first pole. On a non periodic curve last is Poles.Upper(). On a periodic curve last is)#"  , py::arg("Poles"),  py::arg("Last")
          )
        .def_static("Reverse_s",
                    (void (*)( TColgp_Array1OfPnt2d & ,   const Standard_Integer  ) ) static_cast<void (*)( TColgp_Array1OfPnt2d & ,   const Standard_Integer  ) >(&BSplCLib::Reverse),
                    R"#(Reverses the array of poles.)#"  , py::arg("Poles"),  py::arg("Last")
          )
        .def_static("Reverse_s",
                    (void (*)( TColStd_Array1OfReal & ,   const Standard_Integer  ) ) static_cast<void (*)( TColStd_Array1OfReal & ,   const Standard_Integer  ) >(&BSplCLib::Reverse),
                    R"#(Reverses the array of poles.)#"  , py::arg("Weights"),  py::arg("Last")
          )
        .def_static("IsRational_s",
                    (Standard_Boolean (*)(  const TColStd_Array1OfReal & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const TColStd_Array1OfReal & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Real  ) >(&BSplCLib::IsRational),
                    R"#(Returns False if all the weights of the array <Weights> between I1 an I2 are identic. Epsilon is used for comparing weights. If Epsilon is 0. the Epsilon of the first weight is used.)#"  , py::arg("Weights"),  py::arg("I1"),  py::arg("I2"),  py::arg("Epsilon")=static_cast< const Standard_Real>(0.0)
          )
        .def_static("MaxDegree_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&BSplCLib::MaxDegree),
                    R"#(returns the degree maxima for a BSplineCurve.)#" 
          )
        .def_static("AntiBoorScheme_s",
                    (Standard_Boolean (*)(  const Standard_Real ,   const Standard_Integer ,  Standard_Real & ,   const Standard_Integer ,  Standard_Real & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const Standard_Real ,   const Standard_Integer ,  Standard_Real & ,   const Standard_Integer ,  Standard_Real & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Real  ) >(&BSplCLib::AntiBoorScheme),
                    R"#(Compute the content of Pole before the BoorScheme. This method is used to remove poles.)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("Knots"),  py::arg("Dimension"),  py::arg("Poles"),  py::arg("Depth"),  py::arg("Length"),  py::arg("Tolerance")
          )
        .def_static("NoWeights_s",
                    (TColStd_Array1OfReal * (*)() ) static_cast<TColStd_Array1OfReal * (*)() >(&BSplCLib::NoWeights),
                    R"#(Used as argument for a non rational curve.)#" 
          )
        .def_static("NoMults_s",
                    (TColStd_Array1OfInteger * (*)() ) static_cast<TColStd_Array1OfInteger * (*)() >(&BSplCLib::NoMults),
                    R"#(Used as argument for a flatknots evaluation.)#" 
          )
        .def_static("PoleIndex_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfInteger &  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfInteger &  ) >(&BSplCLib::PoleIndex),
                    R"#(Return the index of the first Pole to use on the span Mults(Index) - Mults(Index+1). This index must be added to Poles.Lower().)#"  , py::arg("Degree"),  py::arg("Index"),  py::arg("Periodic"),  py::arg("Mults")
          )
        .def_static("BoorIndex_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer  ) >(&BSplCLib::BoorIndex),
                    R"#(Returns the index in the Boor result array of the poles <Index>. If the Boor algorithm was perform with <Length> and <Depth>.)#"  , py::arg("Index"),  py::arg("Length"),  py::arg("Depth")
          )
        .def_static("PrepareInsertKnots_s",
                    (Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  Standard_Integer & ,  Standard_Integer & ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  Standard_Integer & ,  Standard_Integer & ,   const Standard_Real ,   const Standard_Boolean  ) >(&BSplCLib::PrepareInsertKnots),
                    R"#(Returns in <NbPoles, NbKnots> the new number of poles and knots if the sequence of knots <AddKnots, AddMults> is inserted in the sequence <Knots, Mults>.)#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("AddKnots"),  py::arg("AddMults"),  py::arg("NbPoles"),  py::arg("NbKnots"),  py::arg("Epsilon"),  py::arg("Add")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("InsertKnots_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real ,   const Standard_Boolean  ) >(&BSplCLib::InsertKnots),
                    R"#()#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Dimension"),  py::arg("Poles"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("AddKnots"),  py::arg("AddMults"),  py::arg("NewPoles"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("Epsilon"),  py::arg("Add")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("InsertKnots_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real ,   const Standard_Boolean  ) >(&BSplCLib::InsertKnots),
                    R"#()#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("AddKnots"),  py::arg("AddMults"),  py::arg("NewPoles"),  py::arg("NewWeights"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("Epsilon"),  py::arg("Add")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("InsertKnots_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real ,   const Standard_Boolean  ) >(&BSplCLib::InsertKnots),
                    R"#(Insert a sequence of knots <AddKnots> with multiplicities <AddMults>. <AddKnots> must be a non decreasing sequence and verifies :)#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("AddKnots"),  py::arg("AddMults"),  py::arg("NewPoles"),  py::arg("NewWeights"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("Epsilon"),  py::arg("Add")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("InsertKnot_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::InsertKnot),
                    R"#()#"  , py::arg("UIndex"),  py::arg("U"),  py::arg("UMult"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("InsertKnot_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::InsertKnot),
                    R"#(Insert a new knot U of multiplicity UMult in the knot sequence.)#"  , py::arg("UIndex"),  py::arg("U"),  py::arg("UMult"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("RaiseMultiplicity_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::RaiseMultiplicity),
                    R"#()#"  , py::arg("KnotIndex"),  py::arg("Mult"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("RaiseMultiplicity_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::RaiseMultiplicity),
                    R"#(Raise the multiplicity of knot to <UMult>.)#"  , py::arg("KnotIndex"),  py::arg("Mult"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("RemoveKnot_s",
                    (Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real  ) >(&BSplCLib::RemoveKnot),
                    R"#()#"  , py::arg("Index"),  py::arg("Mult"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Dimension"),  py::arg("Poles"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("Tolerance")
          )
        .def_static("RemoveKnot_s",
                    (Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real  ) >(&BSplCLib::RemoveKnot),
                    R"#()#"  , py::arg("Index"),  py::arg("Mult"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("Tolerance")
          )
        .def_static("RemoveKnot_s",
                    (Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,   const Standard_Real  ) >(&BSplCLib::RemoveKnot),
                    R"#(Decrement the multiplicity of <Knots(Index)> to <Mult>. If <Mult> is null the knot is removed.)#"  , py::arg("Index"),  py::arg("Mult"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("Tolerance")
          )
        .def_static("IncreaseDegreeCountKnots_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfInteger &  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfInteger &  ) >(&BSplCLib::IncreaseDegreeCountKnots),
                    R"#(Returns the number of knots of a curve with multiplicities <Mults> after elevating the degree from <Degree> to <NewDegree>. See the IncreaseDegree method for more comments.)#"  , py::arg("Degree"),  py::arg("NewDegree"),  py::arg("Periodic"),  py::arg("Mults")
          )
        .def_static("IncreaseDegree_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) >(&BSplCLib::IncreaseDegree),
                    R"#()#"  , py::arg("Degree"),  py::arg("NewDegree"),  py::arg("Periodic"),  py::arg("Dimension"),  py::arg("Poles"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewKnots"),  py::arg("NewMults")
          )
        .def_static("IncreaseDegree_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) >(&BSplCLib::IncreaseDegree),
                    R"#()#"  , py::arg("Degree"),  py::arg("NewDegree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights"),  py::arg("NewKnots"),  py::arg("NewMults")
          )
        .def_static("IncreaseDegree_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal * ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) >(&BSplCLib::IncreaseDegree),
                    R"#()#"  , py::arg("Degree"),  py::arg("NewDegree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("NewPoles"),  py::arg("NewWeights"),  py::arg("NewKnots"),  py::arg("NewMults")
          )
        .def_static("IncreaseDegree_s",
                    (void (*)(  const Standard_Integer ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::IncreaseDegree),
                    R"#()#"  , py::arg("NewDegree"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("IncreaseDegree_s",
                    (void (*)(  const Standard_Integer ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::IncreaseDegree),
                    R"#(Increase the degree of a bspline (or bezier) curve of dimension theDimension form theDegree to theNewDegree.)#"  , py::arg("theNewDegree"),  py::arg("thePoles"),  py::arg("theWeights"),  py::arg("theNewPoles"),  py::arg("theNewWeights")
          )
        .def_static("Unperiodize_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal &  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal &  ) >(&BSplCLib::Unperiodize),
                    R"#()#"  , py::arg("Degree"),  py::arg("Dimension"),  py::arg("Mults"),  py::arg("Knots"),  py::arg("Poles"),  py::arg("NewMults"),  py::arg("NewKnots"),  py::arg("NewPoles")
          )
        .def_static("Unperiodize_s",
                    (void (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::Unperiodize),
                    R"#()#"  , py::arg("Degree"),  py::arg("Mults"),  py::arg("Knots"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("NewMults"),  py::arg("NewKnots"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("Unperiodize_s",
                    (void (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::Unperiodize),
                    R"#()#"  , py::arg("Degree"),  py::arg("Mults"),  py::arg("Knots"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("NewMults"),  py::arg("NewKnots"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("Trimming_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal &  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfReal &  ) >(&BSplCLib::Trimming),
                    R"#()#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Dimension"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("Poles"),  py::arg("U1"),  py::arg("U2"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("NewPoles")
          )
        .def_static("Trimming_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::Trimming),
                    R"#()#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("U1"),  py::arg("U2"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("Trimming_s",
                    (void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Integer ,   const Standard_Boolean ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const Standard_Real ,   const Standard_Real ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::Trimming),
                    R"#()#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("U1"),  py::arg("U2"),  py::arg("NewKnots"),  py::arg("NewMults"),  py::arg("NewPoles"),  py::arg("NewWeights")
          )
        .def_static("D0_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt &  ) >(&BSplCLib::D0),
                    R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P")
          )
        .def_static("D0_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d &  ) >(&BSplCLib::D0),
                    R"#()#"  , py::arg("U"),  py::arg("UIndex"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P")
          )
        .def_static("D0_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt &  ) >(&BSplCLib::D0),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P")
          )
        .def_static("D0_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d &  ) >(&BSplCLib::D0),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P")
          )
        .def_static("D1_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt & ,  gp_Vec &  ) >(&BSplCLib::D1),
                    R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P"),  py::arg("V")
          )
        .def_static("D1_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d & ,  gp_Vec2d &  ) >(&BSplCLib::D1),
                    R"#()#"  , py::arg("U"),  py::arg("UIndex"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P"),  py::arg("V")
          )
        .def_static("D1_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec &  ) >(&BSplCLib::D1),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P"),  py::arg("V")
          )
        .def_static("D1_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d &  ) >(&BSplCLib::D1),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P"),  py::arg("V")
          )
        .def_static("D2_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::D2),
                    R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def_static("D2_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::D2),
                    R"#()#"  , py::arg("U"),  py::arg("UIndex"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def_static("D2_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::D2),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def_static("D2_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::D2),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def_static("D3_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::D3),
                    R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def_static("D3_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,   const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::D3),
                    R"#()#"  , py::arg("U"),  py::arg("UIndex"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def_static("D3_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::D3),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def_static("D3_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::D3),
                    R"#()#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def_static("EvalBsplineBasis_s",
                    (Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const Standard_Real ,  Standard_Integer & ,  math_Matrix & ,   const Standard_Boolean  ) ) static_cast<Standard_Integer (*)(  const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const Standard_Real ,  Standard_Integer & ,  math_Matrix & ,   const Standard_Boolean  ) >(&BSplCLib::EvalBsplineBasis),
                    R"#(This evaluates the Bspline Basis at a given parameter Parameter up to the requested DerivativeOrder and store the result in the array BsplineBasis in the following fashion BSplineBasis(1,1) = value of first non vanishing Bspline function which has Index FirstNonZeroBsplineIndex BsplineBasis(1,2) = value of second non vanishing Bspline function which has Index FirstNonZeroBsplineIndex + 1 BsplineBasis(1,n) = value of second non vanishing non vanishing Bspline function which has Index FirstNonZeroBsplineIndex + n (n <= Order) BSplineBasis(2,1) = value of derivative of first non vanishing Bspline function which has Index FirstNonZeroBsplineIndex BSplineBasis(N,1) = value of Nth derivative of first non vanishing Bspline function which has Index FirstNonZeroBsplineIndex if N <= DerivativeOrder + 1)#"  , py::arg("DerivativeOrder"),  py::arg("Order"),  py::arg("FlatKnots"),  py::arg("Parameter"),  py::arg("FirstNonZeroBsplineIndex"),  py::arg("BsplineBasis"),  py::arg("isPeriodic")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("BuildBSpMatrix_s",
                    (Standard_Integer (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const Standard_Integer ,  math_Matrix & ,  Standard_Integer & ,  Standard_Integer &  ) ) static_cast<Standard_Integer (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,   const TColStd_Array1OfReal & ,   const Standard_Integer ,  math_Matrix & ,  Standard_Integer & ,  Standard_Integer &  ) >(&BSplCLib::BuildBSpMatrix),
                    R"#(This Builds a fully blown Matrix of (ni) Bi (tj))#"  , py::arg("Parameters"),  py::arg("OrderArray"),  py::arg("FlatKnots"),  py::arg("Degree"),  py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth")
          )
        .def_static("FactorBandedMatrix_s",
                    (Standard_Integer (*)( math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,  Standard_Integer &  ) ) static_cast<Standard_Integer (*)( math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,  Standard_Integer &  ) >(&BSplCLib::FactorBandedMatrix),
                    R"#(this factors the Banded Matrix in the LU form with a Banded storage of components of the L matrix WARNING : do not use if the Matrix is totally positive (It is the case for Bspline matrices build as above with parameters being the Schoenberg points)#"  , py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth"),  py::arg("PivotIndexProblem")
          )
        .def_static("SolveBandedSystem_s",
                    (Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,  Standard_Real &  ) ) static_cast<Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,  Standard_Real &  ) >(&BSplCLib::SolveBandedSystem),
                    R"#(This solves the system Matrix.X = B with when Matrix is factored in LU form The Array is an seen as an Array[1..N][1..ArrayDimension] with N = the rank of the matrix Matrix. The result is stored in Array when each coordinate is solved that is B is the array whose values are B[i] = Array[i][p] for each p in 1..ArrayDimension)#"  , py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth"),  py::arg("ArrayDimension"),  py::arg("Array")
          )
        .def_static("SolveBandedSystem_s",
                    (Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,  TColgp_Array1OfPnt2d &  ) ) static_cast<Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,  TColgp_Array1OfPnt2d &  ) >(&BSplCLib::SolveBandedSystem),
                    R"#(This solves the system Matrix.X = B with when Matrix is factored in LU form The Array has the length of the rank of the matrix Matrix. The result is stored in Array when each coordinate is solved that is B is the array whose values are B[i] = Array[i][p] for each p in 1..ArrayDimension)#"  , py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth"),  py::arg("Array")
          )
        .def_static("SolveBandedSystem_s",
                    (Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,  TColgp_Array1OfPnt &  ) ) static_cast<Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,  TColgp_Array1OfPnt &  ) >(&BSplCLib::SolveBandedSystem),
                    R"#(This solves the system Matrix.X = B with when Matrix is factored in LU form The Array has the length of the rank of the matrix Matrix. The result is stored in Array when each coordinate is solved that is B is the array whose values are B[i] = Array[i][p] for each p in 1..ArrayDimension)#"  , py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth"),  py::arg("Array")
          )
        .def_static("SolveBandedSystem_s",
                    (Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,   const Standard_Integer ,  Standard_Real & ,  Standard_Real &  ) >(&BSplCLib::SolveBandedSystem),
                    R"#()#"  , py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth"),  py::arg("HomogenousFlag"),  py::arg("ArrayDimension"),  py::arg("Array"),  py::arg("Weights")
          )
        .def_static("SolveBandedSystem_s",
                    (Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal &  ) ) static_cast<Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal &  ) >(&BSplCLib::SolveBandedSystem),
                    R"#(This solves the system Matrix.X = B with when Matrix is factored in LU form The Array is an seen as an Array[1..N][1..ArrayDimension] with N = the rank of the matrix Matrix. The result is stored in Array when each coordinate is solved that is B is the array whose values are B[i] = Array[i][p] for each p in 1..ArrayDimension. If HomogeneousFlag == 0 the Poles are multiplied by the Weights upon Entry and once interpolation is carried over the result of the poles are divided by the result of the interpolation of the weights. Otherwise if HomogenousFlag == 1 the Poles and Weights are treated homogeneously that is that those are interpolated as they are and result is returned without division by the interpolated weights.)#"  , py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth"),  py::arg("HomogenousFlag"),  py::arg("Array"),  py::arg("Weights")
          )
        .def_static("SolveBandedSystem_s",
                    (Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal &  ) ) static_cast<Standard_Integer (*)(  const math_Matrix & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal &  ) >(&BSplCLib::SolveBandedSystem),
                    R"#(This solves the system Matrix.X = B with when Matrix is factored in LU form The Array is an seen as an Array[1..N][1..ArrayDimension] with N = the rank of the matrix Matrix. The result is stored in Array when each coordinate is solved that is B is the array whose values are B[i] = Array[i][p] for each p in 1..ArrayDimension If HomogeneousFlag == 0 the Poles are multiplied by the Weights upon Entry and once interpolation is carried over the result of the poles are divided by the result of the interpolation of the weights. Otherwise if HomogenousFlag == 1 the Poles and Weights are treated homogeneously that is that those are interpolated as they are and result is returned without division by the interpolated weights.)#"  , py::arg("Matrix"),  py::arg("UpperBandWidth"),  py::arg("LowerBandWidth"),  py::arg("HomogeneousFlag"),  py::arg("Array"),  py::arg("Weights")
          )
        .def_static("CacheD0_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt &  ) >(&BSplCLib::CacheD0),
                    R"#(Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights this just evaluates the current point the CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effects)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point")
          )
        .def_static("CacheD0_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d &  ) >(&BSplCLib::CacheD0),
                    R"#(Perform the evaluation of the Bspline Basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights ththe CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point")
          )
        .def_static("CoefsD0_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt &  ) >(&BSplCLib::CoefsD0),
                    R"#(Calls CacheD0 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point")
          )
        .def_static("CoefsD0_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d &  ) >(&BSplCLib::CoefsD0),
                    R"#(Calls CacheD0 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point")
          )
        .def_static("CacheD1_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec &  ) >(&BSplCLib::CacheD1),
                    R"#(Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights this just evaluates the current point the CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effects)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec")
          )
        .def_static("CacheD1_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d &  ) >(&BSplCLib::CacheD1),
                    R"#(Perform the evaluation of the Bspline Basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights ththe CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec")
          )
        .def_static("CoefsD1_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec &  ) >(&BSplCLib::CoefsD1),
                    R"#(Calls CacheD1 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec")
          )
        .def_static("CoefsD1_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d &  ) >(&BSplCLib::CoefsD1),
                    R"#(Calls CacheD1 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec")
          )
        .def_static("CacheD2_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::CacheD2),
                    R"#(Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights this just evaluates the current point the CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effects)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2")
          )
        .def_static("CacheD2_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::CacheD2),
                    R"#(Perform the evaluation of the Bspline Basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights ththe CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2")
          )
        .def_static("CoefsD2_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::CoefsD2),
                    R"#(Calls CacheD1 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2")
          )
        .def_static("CoefsD2_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::CoefsD2),
                    R"#(Calls CacheD1 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2")
          )
        .def_static("CacheD3_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::CacheD3),
                    R"#(Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights this just evaluates the current point the CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effects)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2"),  py::arg("Vec3")
          )
        .def_static("CacheD3_s",
                    (void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::CacheD3),
                    R"#(Perform the evaluation of the Bspline Basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. The Cache must be valid when calling this routine. Geom Package will insure that. and then multiplies by the weights ththe CacheParameter is where the Cache was constructed the SpanLength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("CacheParameter"),  py::arg("SpanLenght"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2"),  py::arg("Vec3")
          )
        .def_static("CoefsD3_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) >(&BSplCLib::CoefsD3),
                    R"#(Calls CacheD1 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2"),  py::arg("Vec3")
          )
        .def_static("CoefsD3_s",
                    (void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) ) static_cast<void (*)(  const Standard_Real ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) >(&BSplCLib::CoefsD3),
                    R"#(Calls CacheD1 for Bezier Curves Arrays computed with the method PolesCoefficients. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("U"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point"),  py::arg("Vec1"),  py::arg("Vec2"),  py::arg("Vec3")
          )
        .def_static("BuildCache_s",
                    (void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::BuildCache),
                    R"#(Perform the evaluation of the Taylor expansion of the Bspline normalized between 0 and 1. If rational computes the homogeneous Taylor expansion for the numerator and stores it in CachePoles)#"  , py::arg("U"),  py::arg("InverseOfSpanDomain"),  py::arg("PeriodicFlag"),  py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("CachePoles"),  py::arg("CacheWeights")
          )
        .def_static("BuildCache_s",
                    (void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::BuildCache),
                    R"#(Perform the evaluation of the Taylor expansion of the Bspline normalized between 0 and 1. If rational computes the homogeneous Taylor expansion for the numerator and stores it in CachePoles)#"  , py::arg("U"),  py::arg("InverseOfSpanDomain"),  py::arg("PeriodicFlag"),  py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("CachePoles"),  py::arg("CacheWeights")
          )
        .def_static("BuildCache_s",
                    (void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColStd_Array2OfReal &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColStd_Array2OfReal &  ) >(&BSplCLib::BuildCache),
                    R"#(Perform the evaluation of the Taylor expansion of the Bspline normalized between 0 and 1. Structure of result optimized for BSplCLib_Cache.)#"  , py::arg("theParameter"),  py::arg("theSpanDomain"),  py::arg("thePeriodicFlag"),  py::arg("theDegree"),  py::arg("theSpanIndex"),  py::arg("theFlatKnots"),  py::arg("thePoles"),  py::arg("theWeights"),  py::arg("theCacheArray")
          )
        .def_static("BuildCache_s",
                    (void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColStd_Array2OfReal &  ) ) static_cast<void (*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Integer ,   const Standard_Integer ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColStd_Array2OfReal &  ) >(&BSplCLib::BuildCache),
                    R"#(Perform the evaluation of the Taylor expansion of the Bspline normalized between 0 and 1. Structure of result optimized for BSplCLib_Cache.)#"  , py::arg("theParameter"),  py::arg("theSpanDomain"),  py::arg("thePeriodicFlag"),  py::arg("theDegree"),  py::arg("theSpanIndex"),  py::arg("theFlatKnots"),  py::arg("thePoles"),  py::arg("theWeights"),  py::arg("theCacheArray")
          )
        .def_static("PolesCoefficients_s",
                    (void (*)(  const TColgp_Array1OfPnt2d & ,  TColgp_Array1OfPnt2d &  ) ) static_cast<void (*)(  const TColgp_Array1OfPnt2d & ,  TColgp_Array1OfPnt2d &  ) >(&BSplCLib::PolesCoefficients),
                    R"#()#"  , py::arg("Poles"),  py::arg("CachePoles")
          )
        .def_static("PolesCoefficients_s",
                    (void (*)(  const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::PolesCoefficients),
                    R"#()#"  , py::arg("Poles"),  py::arg("Weights"),  py::arg("CachePoles"),  py::arg("CacheWeights")
          )
        .def_static("PolesCoefficients_s",
                    (void (*)(  const TColgp_Array1OfPnt & ,  TColgp_Array1OfPnt &  ) ) static_cast<void (*)(  const TColgp_Array1OfPnt & ,  TColgp_Array1OfPnt &  ) >(&BSplCLib::PolesCoefficients),
                    R"#()#"  , py::arg("Poles"),  py::arg("CachePoles")
          )
        .def_static("PolesCoefficients_s",
                    (void (*)(  const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) ) static_cast<void (*)(  const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal * ,  TColgp_Array1OfPnt & ,  TColStd_Array1OfReal *  ) >(&BSplCLib::PolesCoefficients),
                    R"#(Encapsulation of BuildCache to perform the evaluation of the Taylor expansion for beziercurves at parameter 0. Warning: To be used for Beziercurves ONLY!!!)#"  , py::arg("Poles"),  py::arg("Weights"),  py::arg("CachePoles"),  py::arg("CacheWeights")
          )
        .def_static("FlatBezierKnots_s",
                    ( const Standard_Real & (*)(  const Standard_Integer  ) ) static_cast< const Standard_Real & (*)(  const Standard_Integer  ) >(&BSplCLib::FlatBezierKnots),
                    R"#(Returns pointer to statically allocated array representing flat knots for bezier curve of the specified degree. Raises OutOfRange if Degree > MaxDegree())#"  , py::arg("Degree")
          )
        .def_static("BuildSchoenbergPoints_s",
                    (void (*)(  const Standard_Integer ,   const TColStd_Array1OfReal & ,  TColStd_Array1OfReal &  ) ) static_cast<void (*)(  const Standard_Integer ,   const TColStd_Array1OfReal & ,  TColStd_Array1OfReal &  ) >(&BSplCLib::BuildSchoenbergPoints),
                    R"#(builds the Schoenberg points from the flat knot used to interpolate a BSpline since the BSpline matrix is invertible.)#"  , py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Parameters")
          )
        .def_static("Intervals_s",
                    (Standard_Integer (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  Standard_Integer ,  Standard_Boolean ,  Standard_Integer ,  Standard_Real ,  Standard_Real ,  Standard_Real ,  TColStd_Array1OfReal *  ) ) static_cast<Standard_Integer (*)(  const TColStd_Array1OfReal & ,   const TColStd_Array1OfInteger & ,  Standard_Integer ,  Standard_Boolean ,  Standard_Integer ,  Standard_Real ,  Standard_Real ,  Standard_Real ,  TColStd_Array1OfReal *  ) >(&BSplCLib::Intervals),
                    R"#(Splits the given range to BSpline intervals of given continuity)#"  , py::arg("theKnots"),  py::arg("theMults"),  py::arg("theDegree"),  py::arg("isPeriodic"),  py::arg("theContinuity"),  py::arg("theFirst"),  py::arg("theLast"),  py::arg("theTolerance"),  py::arg("theIntervals")
          )
    // static methods using call by reference i.s.o. return
        .def_static("Hunt_s",
            []( const TColStd_Array1OfReal & theArray, const Standard_Real theX ){
                Standard_Integer  theXPos;

                BSplCLib::Hunt(theArray,theX,theXPos);
                
return std::make_tuple(theXPos); },
            R"#(This routine searches the position of the real value theX in the monotonically increasing set of real values theArray using bisection algorithm.)#"  , py::arg("theArray"),  py::arg("theX")
          )
        .def_static("LocateParameter_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger & Mults, const Standard_Real U, const Standard_Boolean IsPeriodic, const Standard_Integer FromK1, const Standard_Integer ToK2 ){
                Standard_Integer  KnotIndex;
                Standard_Real  NewU;

                BSplCLib::LocateParameter(Degree,Knots,Mults,U,IsPeriodic,FromK1,ToK2,KnotIndex,NewU);
                
return std::make_tuple(KnotIndex,NewU); },
            R"#(Locates the parametric value U in the knots sequence between the knot K1 and the knot K2. The value return in Index verifies.)#"  , py::arg("Degree"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("U"),  py::arg("IsPeriodic"),  py::arg("FromK1"),  py::arg("ToK2")
          )
        .def_static("LocateParameter_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & Knots, const Standard_Real U, const Standard_Boolean IsPeriodic, const Standard_Integer FromK1, const Standard_Integer ToK2 ){
                Standard_Integer  KnotIndex;
                Standard_Real  NewU;

                BSplCLib::LocateParameter(Degree,Knots,U,IsPeriodic,FromK1,ToK2,KnotIndex,NewU);
                
return std::make_tuple(KnotIndex,NewU); },
            R"#(Locates the parametric value U in the knots sequence between the knot K1 and the knot K2. The value return in Index verifies.)#"  , py::arg("Degree"),  py::arg("Knots"),  py::arg("U"),  py::arg("IsPeriodic"),  py::arg("FromK1"),  py::arg("ToK2")
          )
        .def_static("LocateParameter_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger * Mults, const Standard_Real U, const Standard_Boolean Periodic ){
                Standard_Integer  Index;
                Standard_Real  NewU;

                BSplCLib::LocateParameter(Degree,Knots,Mults,U,Periodic,Index,NewU);
                
return std::make_tuple(Index,NewU); },
            R"#()#"  , py::arg("Degree"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("U"),  py::arg("Periodic")
          )
        .def_static("KnotAnalysis_s",
            []( const Standard_Integer Degree, const Standard_Boolean Periodic, const TColStd_Array1OfReal & CKnots, const TColStd_Array1OfInteger & CMults,GeomAbs_BSplKnotDistribution & KnotForm ){
                Standard_Integer  MaxKnotMult;

                BSplCLib::KnotAnalysis(Degree,Periodic,CKnots,CMults,KnotForm,MaxKnotMult);
                
return std::make_tuple(MaxKnotMult); },
            R"#(Analyzes the array of knots. Returns the form and the maximum knot multiplicity.)#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("CKnots"),  py::arg("CMults"),  py::arg("KnotForm")
          )
        .def_static("Eval_s",
            []( const Standard_Real U, const Standard_Integer Degree, const Standard_Integer Dimension ){
                Standard_Real  Knots;
                Standard_Real  Poles;

                BSplCLib::Eval(U,Degree,Knots,Dimension,Poles);
                
return std::make_tuple(Knots,Poles); },
            R"#(Perform the Boor algorithm to evaluate a point at parameter <U>, with <Degree> and <Dimension>.)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("Dimension")
          )
        .def_static("BoorScheme_s",
            []( const Standard_Real U, const Standard_Integer Degree, const Standard_Integer Dimension, const Standard_Integer Depth, const Standard_Integer Length ){
                Standard_Real  Knots;
                Standard_Real  Poles;

                BSplCLib::BoorScheme(U,Degree,Knots,Dimension,Poles,Depth,Length);
                
return std::make_tuple(Knots,Poles); },
            R"#(Performs the Boor Algorithm at parameter <U> with the given <Degree> and the array of <Knots> on the poles <Poles> of dimension <Dimension>. The schema is computed until level <Depth> on a basis of <Length+1> poles.)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("Dimension"),  py::arg("Depth"),  py::arg("Length")
          )
        .def_static("Derivative_s",
            []( const Standard_Integer Degree, const Standard_Integer Dimension, const Standard_Integer Length, const Standard_Integer Order ){
                Standard_Real  Knots;
                Standard_Real  Poles;

                BSplCLib::Derivative(Degree,Knots,Dimension,Length,Order,Poles);
                
return std::make_tuple(Knots,Poles); },
            R"#(Computes the poles of the BSpline giving the derivatives of order <Order>.)#"  , py::arg("Degree"),  py::arg("Dimension"),  py::arg("Length"),  py::arg("Order")
          )
        .def_static("Bohm_s",
            []( const Standard_Real U, const Standard_Integer Degree, const Standard_Integer N, const Standard_Integer Dimension ){
                Standard_Real  Knots;
                Standard_Real  Poles;

                BSplCLib::Bohm(U,Degree,N,Knots,Dimension,Poles);
                
return std::make_tuple(Knots,Poles); },
            R"#(Performs the Bohm Algorithm at parameter <U>. This algorithm computes the value and all the derivatives up to order N (N <= Degree).)#"  , py::arg("U"),  py::arg("Degree"),  py::arg("N"),  py::arg("Dimension")
          )
        .def_static("BuildKnots_s",
            []( const Standard_Integer Degree, const Standard_Integer Index, const Standard_Boolean Periodic, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger * Mults ){
                Standard_Real  LK;

                BSplCLib::BuildKnots(Degree,Index,Periodic,Knots,Mults,LK);
                
return std::make_tuple(LK); },
            R"#(Stores in LK the useful knots for the BoorSchem on the span Knots(Index) - Knots(Index+1))#"  , py::arg("Degree"),  py::arg("Index"),  py::arg("Periodic"),  py::arg("Knots"),  py::arg("Mults")
          )
        .def_static("BuildEval_s",
            []( const Standard_Integer Degree, const Standard_Integer Index, const TColStd_Array1OfReal & Poles, const TColStd_Array1OfReal * Weights ){
                Standard_Real  LP;

                BSplCLib::BuildEval(Degree,Index,Poles,Weights,LP);
                
return std::make_tuple(LP); },
            R"#()#"  , py::arg("Degree"),  py::arg("Index"),  py::arg("Poles"),  py::arg("Weights")
          )
        .def_static("BuildEval_s",
            []( const Standard_Integer Degree, const Standard_Integer Index, const TColgp_Array1OfPnt & Poles, const TColStd_Array1OfReal * Weights ){
                Standard_Real  LP;

                BSplCLib::BuildEval(Degree,Index,Poles,Weights,LP);
                
return std::make_tuple(LP); },
            R"#()#"  , py::arg("Degree"),  py::arg("Index"),  py::arg("Poles"),  py::arg("Weights")
          )
        .def_static("BuildEval_s",
            []( const Standard_Integer Degree, const Standard_Integer Index, const TColgp_Array1OfPnt2d & Poles, const TColStd_Array1OfReal * Weights ){
                Standard_Real  LP;

                BSplCLib::BuildEval(Degree,Index,Poles,Weights,LP);
                
return std::make_tuple(LP); },
            R"#(Copy in <LP> the poles and weights for the Eval scheme. starting from Poles(Poles.Lower()+Index))#"  , py::arg("Degree"),  py::arg("Index"),  py::arg("Poles"),  py::arg("Weights")
          )
        .def_static("BuildBoor_s",
            []( const Standard_Integer Index, const Standard_Integer Length, const Standard_Integer Dimension, const TColStd_Array1OfReal & Poles ){
                Standard_Real  LP;

                BSplCLib::BuildBoor(Index,Length,Dimension,Poles,LP);
                
return std::make_tuple(LP); },
            R"#(Copy in <LP> poles for <Dimension> Boor scheme. Starting from <Index> * <Dimension>, copy <Length+1> poles.)#"  , py::arg("Index"),  py::arg("Length"),  py::arg("Dimension"),  py::arg("Poles")
          )
        .def_static("GetPole_s",
            []( const Standard_Integer Index, const Standard_Integer Length, const Standard_Integer Depth, const Standard_Integer Dimension,TColStd_Array1OfReal & Pole ){
                Standard_Real  LocPoles;
                Standard_Integer  Position;

                BSplCLib::GetPole(Index,Length,Depth,Dimension,LocPoles,Position,Pole);
                
return std::make_tuple(LocPoles,Position); },
            R"#(Copy the pole at position <Index> in the Boor scheme of dimension <Dimension> to <Position> in the array <Pole>. <Position> is updated.)#"  , py::arg("Index"),  py::arg("Length"),  py::arg("Depth"),  py::arg("Dimension"),  py::arg("Pole")
          )
        .def_static("PrepareUnperiodize_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfInteger & Mults ){
                Standard_Integer  NbKnots;
                Standard_Integer  NbPoles;

                BSplCLib::PrepareUnperiodize(Degree,Mults,NbKnots,NbPoles);
                
return std::make_tuple(NbKnots,NbPoles); },
            R"#(Set in <NbKnots> and <NbPolesToAdd> the number of Knots and Poles of the NotPeriodic Curve identical at the periodic curve with a degree <Degree> , a knots-distribution with Multiplicities <Mults>.)#"  , py::arg("Degree"),  py::arg("Mults")
          )
        .def_static("PrepareTrimming_s",
            []( const Standard_Integer Degree, const Standard_Boolean Periodic, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger & Mults, const Standard_Real U1, const Standard_Real U2 ){
                Standard_Integer  NbKnots;
                Standard_Integer  NbPoles;

                BSplCLib::PrepareTrimming(Degree,Periodic,Knots,Mults,U1,U2,NbKnots,NbPoles);
                
return std::make_tuple(NbKnots,NbPoles); },
            R"#(Set in <NbKnots> and <NbPoles> the number of Knots and Poles of the curve resulting from the trimming of the BSplinecurve defined with <degree>, <knots>, <mults>)#"  , py::arg("Degree"),  py::arg("Periodic"),  py::arg("Knots"),  py::arg("Mults"),  py::arg("U1"),  py::arg("U2")
          )
        .def_static("D0_s",
            []( const Standard_Real U, const Standard_Integer Index, const Standard_Integer Degree, const Standard_Boolean Periodic, const TColStd_Array1OfReal & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger * Mults ){
                Standard_Real  P;

                BSplCLib::D0(U,Index,Degree,Periodic,Poles,Weights,Knots,Mults,P);
                
return std::make_tuple(P); },
            R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults")
          )
        .def_static("D1_s",
            []( const Standard_Real U, const Standard_Integer Index, const Standard_Integer Degree, const Standard_Boolean Periodic, const TColStd_Array1OfReal & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger * Mults ){
                Standard_Real  P;
                Standard_Real  V;

                BSplCLib::D1(U,Index,Degree,Periodic,Poles,Weights,Knots,Mults,P,V);
                
return std::make_tuple(P,V); },
            R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults")
          )
        .def_static("D2_s",
            []( const Standard_Real U, const Standard_Integer Index, const Standard_Integer Degree, const Standard_Boolean Periodic, const TColStd_Array1OfReal & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger * Mults ){
                Standard_Real  P;
                Standard_Real  V1;
                Standard_Real  V2;

                BSplCLib::D2(U,Index,Degree,Periodic,Poles,Weights,Knots,Mults,P,V1,V2);
                
return std::make_tuple(P,V1,V2); },
            R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults")
          )
        .def_static("D3_s",
            []( const Standard_Real U, const Standard_Integer Index, const Standard_Integer Degree, const Standard_Boolean Periodic, const TColStd_Array1OfReal & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & Knots, const TColStd_Array1OfInteger * Mults ){
                Standard_Real  P;
                Standard_Real  V1;
                Standard_Real  V2;
                Standard_Real  V3;

                BSplCLib::D3(U,Index,Degree,Periodic,Poles,Weights,Knots,Mults,P,V1,V2,V3);
                
return std::make_tuple(P,V1,V2,V3); },
            R"#()#"  , py::arg("U"),  py::arg("Index"),  py::arg("Degree"),  py::arg("Periodic"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Knots"),  py::arg("Mults")
          )
        .def_static("MergeBSplineKnots_s",
            []( const Standard_Real Tolerance, const Standard_Real StartValue, const Standard_Real EndValue, const Standard_Integer Degree1, const TColStd_Array1OfReal & Knots1, const TColStd_Array1OfInteger & Mults1, const Standard_Integer Degree2, const TColStd_Array1OfReal & Knots2, const TColStd_Array1OfInteger & Mults2,TColStd_HArray1OfReal& NewKnots,TColStd_HArray1OfInteger& NewMults ){
                Standard_Integer  NumPoles;
                handle<TColStd_HArray1OfReal>  NewKnots_ptr; NewKnots_ptr = &NewKnots;
                handle<TColStd_HArray1OfInteger>  NewMults_ptr; NewMults_ptr = &NewMults;

                BSplCLib::MergeBSplineKnots(Tolerance,StartValue,EndValue,Degree1,Knots1,Mults1,Degree2,Knots2,Mults2,NumPoles,NewKnots_ptr,NewMults_ptr);
                if ( NewKnots_ptr.get() != &NewKnots ) copy_if_copy_constructible(NewKnots, *NewKnots_ptr);
                if ( NewMults_ptr.get() != &NewMults ) copy_if_copy_constructible(NewMults, *NewMults_ptr);

return std::make_tuple(NumPoles); },
            R"#(Merges two knot vector by setting the starting and ending values to StartValue and EndValue)#"  , py::arg("Tolerance"),  py::arg("StartValue"),  py::arg("EndValue"),  py::arg("Degree1"),  py::arg("Knots1"),  py::arg("Mults1"),  py::arg("Degree2"),  py::arg("Knots2"),  py::arg("Mults2"),  py::arg("NewKnots"),  py::arg("NewMults")
          )
        .def_static("FunctionReparameterise_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const Standard_Integer PolesDimension, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree ){
                Standard_Real  Poles;
                Standard_Real  NewPoles;
                Standard_Integer  theStatus;

                BSplCLib::FunctionReparameterise(Function,BSplineDegree,BSplineFlatKnots,PolesDimension,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(Poles,NewPoles,theStatus); },
            R"#(This function will compose a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] with a function a(t) which is assumed to satisfy the following:)#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("PolesDimension"),  py::arg("FlatKnots"),  py::arg("NewDegree")
          )
        .def_static("FunctionReparameterise_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const TColStd_Array1OfReal & Poles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree,TColStd_Array1OfReal & NewPoles ){
                Standard_Integer  theStatus;

                BSplCLib::FunctionReparameterise(Function,BSplineDegree,BSplineFlatKnots,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(theStatus); },
            R"#(This function will compose a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] with a function a(t) which is assumed to satisfy the following:)#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("Poles"),  py::arg("FlatKnots"),  py::arg("NewDegree"),  py::arg("NewPoles")
          )
        .def_static("FunctionReparameterise_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const TColgp_Array1OfPnt & Poles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree,TColgp_Array1OfPnt & NewPoles ){
                Standard_Integer  theStatus;

                BSplCLib::FunctionReparameterise(Function,BSplineDegree,BSplineFlatKnots,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(theStatus); },
            R"#(this will compose a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] with a function a(t) which is assumed to satisfy the following : 1. F(a(t)) is a polynomial BSpline that can be expressed exactly as a BSpline of degree NewDegree on the knots FlatKnots 2. a(t) defines a differentiable isomorphism between the range of FlatKnots to the range of BSplineFlatKnots which is the same as the range of F(t) Warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method theStatus will return 0 if OK else it will return the pivot index of the matrix that was inverted to compute the multiplied BSpline : the method used is interpolation at Schoenenberg points of F(a(t)))#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("Poles"),  py::arg("FlatKnots"),  py::arg("NewDegree"),  py::arg("NewPoles")
          )
        .def_static("FunctionReparameterise_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const TColgp_Array1OfPnt2d & Poles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree,TColgp_Array1OfPnt2d & NewPoles ){
                Standard_Integer  theStatus;

                BSplCLib::FunctionReparameterise(Function,BSplineDegree,BSplineFlatKnots,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(theStatus); },
            R"#(this will compose a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] with a function a(t) which is assumed to satisfy the following : 1. F(a(t)) is a polynomial BSpline that can be expressed exactly as a BSpline of degree NewDegree on the knots FlatKnots 2. a(t) defines a differentiable isomorphism between the range of FlatKnots to the range of BSplineFlatKnots which is the same as the range of F(t) Warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method theStatus will return 0 if OK else it will return the pivot index of the matrix that was inverted to compute the multiplied BSpline : the method used is interpolation at Schoenenberg points of F(a(t)))#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("Poles"),  py::arg("FlatKnots"),  py::arg("NewDegree"),  py::arg("NewPoles")
          )
        .def_static("FunctionMultiply_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const Standard_Integer PolesDimension, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree ){
                Standard_Real  Poles;
                Standard_Real  NewPoles;
                Standard_Integer  theStatus;

                BSplCLib::FunctionMultiply(Function,BSplineDegree,BSplineFlatKnots,PolesDimension,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(Poles,NewPoles,theStatus); },
            R"#(this will multiply a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * F(t) is a polynomial BSpline that can be expressed exactly as a BSpline of degree NewDegree on the knots FlatKnots 2. the range of a(t) is the same as the range of F(t) Warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method theStatus will return 0 if OK else it will return the pivot index of the matrix that was inverted to compute the multiplied BSpline : the method used is interpolation at Schoenenberg points of a(t)*F(t))#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("PolesDimension"),  py::arg("FlatKnots"),  py::arg("NewDegree")
          )
        .def_static("FunctionMultiply_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const TColStd_Array1OfReal & Poles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree,TColStd_Array1OfReal & NewPoles ){
                Standard_Integer  theStatus;

                BSplCLib::FunctionMultiply(Function,BSplineDegree,BSplineFlatKnots,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(theStatus); },
            R"#(this will multiply a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * F(t) is a polynomial BSpline that can be expressed exactly as a BSpline of degree NewDegree on the knots FlatKnots 2. the range of a(t) is the same as the range of F(t) Warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method theStatus will return 0 if OK else it will return the pivot index of the matrix that was inverted to compute the multiplied BSpline : the method used is interpolation at Schoenenberg points of a(t)*F(t))#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("Poles"),  py::arg("FlatKnots"),  py::arg("NewDegree"),  py::arg("NewPoles")
          )
        .def_static("FunctionMultiply_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const TColgp_Array1OfPnt2d & Poles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree,TColgp_Array1OfPnt2d & NewPoles ){
                Standard_Integer  theStatus;

                BSplCLib::FunctionMultiply(Function,BSplineDegree,BSplineFlatKnots,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(theStatus); },
            R"#(this will multiply a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * F(t) is a polynomial BSpline that can be expressed exactly as a BSpline of degree NewDegree on the knots FlatKnots 2. the range of a(t) is the same as the range of F(t) Warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method theStatus will return 0 if OK else it will return the pivot index of the matrix that was inverted to compute the multiplied BSpline : the method used is interpolation at Schoenenberg points of a(t)*F(t))#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("Poles"),  py::arg("FlatKnots"),  py::arg("NewDegree"),  py::arg("NewPoles")
          )
        .def_static("FunctionMultiply_s",
            []( const BSplCLib_EvaluatorFunction & Function, const Standard_Integer BSplineDegree, const TColStd_Array1OfReal & BSplineFlatKnots, const TColgp_Array1OfPnt & Poles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer NewDegree,TColgp_Array1OfPnt & NewPoles ){
                Standard_Integer  theStatus;

                BSplCLib::FunctionMultiply(Function,BSplineDegree,BSplineFlatKnots,Poles,FlatKnots,NewDegree,NewPoles,theStatus);
                
return std::make_tuple(theStatus); },
            R"#(this will multiply a given Vectorial BSpline F(t) defined by its BSplineDegree and BSplineFlatKnotsl, its Poles array which are coded as an array of Real of the form [1..NumPoles][1..PolesDimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * F(t) is a polynomial BSpline that can be expressed exactly as a BSpline of degree NewDegree on the knots FlatKnots 2. the range of a(t) is the same as the range of F(t) Warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method theStatus will return 0 if OK else it will return the pivot index of the matrix that was inverted to compute the multiplied BSpline : the method used is interpolation at Schoenenberg points of a(t)*F(t))#"  , py::arg("Function"),  py::arg("BSplineDegree"),  py::arg("BSplineFlatKnots"),  py::arg("Poles"),  py::arg("FlatKnots"),  py::arg("NewDegree"),  py::arg("NewPoles")
          )
        .def_static("Eval_s",
            []( const Standard_Real U, const Standard_Boolean PeriodicFlag, const Standard_Integer DerivativeRequest, const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer ArrayDimension ){
                Standard_Integer  ExtrapMode;
                Standard_Real  Poles;
                Standard_Real  Result;

                BSplCLib::Eval(U,PeriodicFlag,DerivativeRequest,ExtrapMode,Degree,FlatKnots,ArrayDimension,Poles,Result);
                
return std::make_tuple(ExtrapMode,Poles,Result); },
            R"#(Perform the De Boor algorithm to evaluate a point at parameter <U>, with <Degree> and <Dimension>.)#"  , py::arg("U"),  py::arg("PeriodicFlag"),  py::arg("DerivativeRequest"),  py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("ArrayDimension")
          )
        .def_static("Eval_s",
            []( const Standard_Real U, const Standard_Boolean PeriodicFlag, const Standard_Integer DerivativeRequest, const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer ArrayDimension ){
                Standard_Integer  ExtrapMode;
                Standard_Real  Poles;
                Standard_Real  Weights;
                Standard_Real  PolesResult;
                Standard_Real  WeightsResult;

                BSplCLib::Eval(U,PeriodicFlag,DerivativeRequest,ExtrapMode,Degree,FlatKnots,ArrayDimension,Poles,Weights,PolesResult,WeightsResult);
                
return std::make_tuple(ExtrapMode,Poles,Weights,PolesResult,WeightsResult); },
            R"#(Perform the De Boor algorithm to evaluate a point at parameter <U>, with <Degree> and <Dimension>. Evaluates by multiplying the Poles by the Weights and gives the homogeneous result in PolesResult that is the results of the evaluation of the numerator once it has been multiplied by the weights and in WeightsResult one has the result of the evaluation of the denominator)#"  , py::arg("U"),  py::arg("PeriodicFlag"),  py::arg("DerivativeRequest"),  py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("ArrayDimension")
          )
        .def_static("Eval_s",
            []( const Standard_Real U, const Standard_Boolean PeriodicFlag, const Standard_Boolean HomogeneousFlag, const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColgp_Array1OfPnt & Poles, const TColStd_Array1OfReal & Weights,gp_Pnt & Point ){
                Standard_Integer  ExtrapMode;
                Standard_Real  Weight;

                BSplCLib::Eval(U,PeriodicFlag,HomogeneousFlag,ExtrapMode,Degree,FlatKnots,Poles,Weights,Point,Weight);
                
return std::make_tuple(ExtrapMode,Weight); },
            R"#(Perform the evaluation of the Bspline Basis and then multiplies by the weights this just evaluates the current point)#"  , py::arg("U"),  py::arg("PeriodicFlag"),  py::arg("HomogeneousFlag"),  py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point")
          )
        .def_static("Eval_s",
            []( const Standard_Real U, const Standard_Boolean PeriodicFlag, const Standard_Boolean HomogeneousFlag, const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColgp_Array1OfPnt2d & Poles, const TColStd_Array1OfReal & Weights,gp_Pnt2d & Point ){
                Standard_Integer  ExtrapMode;
                Standard_Real  Weight;

                BSplCLib::Eval(U,PeriodicFlag,HomogeneousFlag,ExtrapMode,Degree,FlatKnots,Poles,Weights,Point,Weight);
                
return std::make_tuple(ExtrapMode,Weight); },
            R"#(Perform the evaluation of the Bspline Basis and then multiplies by the weights this just evaluates the current point)#"  , py::arg("U"),  py::arg("PeriodicFlag"),  py::arg("HomogeneousFlag"),  py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("Point")
          )
        .def_static("TangExtendToConstraint_s",
            []( const TColStd_Array1OfReal & FlatKnots, const Standard_Real C1Coefficient, const Standard_Integer NumPoles, const Standard_Integer Dimension, const Standard_Integer Degree, const TColStd_Array1OfReal & ConstraintPoint, const Standard_Integer Continuity, const Standard_Boolean After ){
                Standard_Real  Poles;
                Standard_Integer  NbPolesResult;
                Standard_Integer  NbKnotsRsult;
                Standard_Real  KnotsResult;
                Standard_Real  PolesResult;

                BSplCLib::TangExtendToConstraint(FlatKnots,C1Coefficient,NumPoles,Poles,Dimension,Degree,ConstraintPoint,Continuity,After,NbPolesResult,NbKnotsRsult,KnotsResult,PolesResult);
                
return std::make_tuple(Poles,NbPolesResult,NbKnotsRsult,KnotsResult,PolesResult); },
            R"#(Extend a BSpline nD using the tangency map <C1Coefficient> is the coefficient of reparametrisation <Continuity> must be equal to 1, 2 or 3. <Degree> must be greater or equal than <Continuity> + 1.)#"  , py::arg("FlatKnots"),  py::arg("C1Coefficient"),  py::arg("NumPoles"),  py::arg("Dimension"),  py::arg("Degree"),  py::arg("ConstraintPoint"),  py::arg("Continuity"),  py::arg("After")
          )
        .def_static("Interpolate_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColStd_Array1OfReal & Parameters, const TColStd_Array1OfInteger & ContactOrderArray,TColgp_Array1OfPnt & Poles ){
                Standard_Integer  InversionProblem;

                BSplCLib::Interpolate(Degree,FlatKnots,Parameters,ContactOrderArray,Poles,InversionProblem);
                
return std::make_tuple(InversionProblem); },
            R"#(Performs the interpolation of the data given in the Poles array according to the requests in ContactOrderArray that is : if ContactOrderArray(i) has value d it means that Poles(i) contains the dth derivative of the function to be interpolated. The length L of the following arrays must be the same : Parameters, ContactOrderArray, Poles, The length of FlatKnots is Degree + L + 1 Warning: the method used to do that interpolation is gauss elimination WITHOUT pivoting. Thus if the diagonal is not dominant there is no guarantee that the algorithm will work. Nevertheless for Cubic interpolation or interpolation at Scheonberg points the method will work The InversionProblem will report 0 if there was no problem else it will give the index of the faulty pivot)#"  , py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Parameters"),  py::arg("ContactOrderArray"),  py::arg("Poles")
          )
        .def_static("Interpolate_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColStd_Array1OfReal & Parameters, const TColStd_Array1OfInteger & ContactOrderArray,TColgp_Array1OfPnt2d & Poles ){
                Standard_Integer  InversionProblem;

                BSplCLib::Interpolate(Degree,FlatKnots,Parameters,ContactOrderArray,Poles,InversionProblem);
                
return std::make_tuple(InversionProblem); },
            R"#(Performs the interpolation of the data given in the Poles array according to the requests in ContactOrderArray that is : if ContactOrderArray(i) has value d it means that Poles(i) contains the dth derivative of the function to be interpolated. The length L of the following arrays must be the same : Parameters, ContactOrderArray, Poles, The length of FlatKnots is Degree + L + 1 Warning: the method used to do that interpolation is gauss elimination WITHOUT pivoting. Thus if the diagonal is not dominant there is no guarantee that the algorithm will work. Nevertheless for Cubic interpolation at knots or interpolation at Scheonberg points the method will work. The InversionProblem w ll report 0 if there was no problem else it will give the index of the faulty pivot)#"  , py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Parameters"),  py::arg("ContactOrderArray"),  py::arg("Poles")
          )
        .def_static("Interpolate_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColStd_Array1OfReal & Parameters, const TColStd_Array1OfInteger & ContactOrderArray,TColgp_Array1OfPnt & Poles,TColStd_Array1OfReal & Weights ){
                Standard_Integer  InversionProblem;

                BSplCLib::Interpolate(Degree,FlatKnots,Parameters,ContactOrderArray,Poles,Weights,InversionProblem);
                
return std::make_tuple(InversionProblem); },
            R"#(Performs the interpolation of the data given in the Poles array according to the requests in ContactOrderArray that is : if ContactOrderArray(i) has value d it means that Poles(i) contains the dth derivative of the function to be interpolated. The length L of the following arrays must be the same : Parameters, ContactOrderArray, Poles, The length of FlatKnots is Degree + L + 1 Warning: the method used to do that interpolation is gauss elimination WITHOUT pivoting. Thus if the diagonal is not dominant there is no guarantee that the algorithm will work. Nevertheless for Cubic interpolation at knots or interpolation at Scheonberg points the method will work. The InversionProblem will report 0 if there was no problem else it will give the index of the faulty pivot)#"  , py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Parameters"),  py::arg("ContactOrderArray"),  py::arg("Poles"),  py::arg("Weights")
          )
        .def_static("Interpolate_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColStd_Array1OfReal & Parameters, const TColStd_Array1OfInteger & ContactOrderArray,TColgp_Array1OfPnt2d & Poles,TColStd_Array1OfReal & Weights ){
                Standard_Integer  InversionProblem;

                BSplCLib::Interpolate(Degree,FlatKnots,Parameters,ContactOrderArray,Poles,Weights,InversionProblem);
                
return std::make_tuple(InversionProblem); },
            R"#(Performs the interpolation of the data given in the Poles array according to the requests in ContactOrderArray that is : if ContactOrderArray(i) has value d it means that Poles(i) contains the dth derivative of the function to be interpolated. The length L of the following arrays must be the same : Parameters, ContactOrderArray, Poles, The length of FlatKnots is Degree + L + 1 Warning: the method used to do that interpolation is gauss elimination WITHOUT pivoting. Thus if the diagonal is not dominant there is no guarantee that the algorithm will work. Nevertheless for Cubic interpolation at knots or interpolation at Scheonberg points the method will work. The InversionProblem w ll report 0 if there was no problem else it will give the i)#"  , py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Parameters"),  py::arg("ContactOrderArray"),  py::arg("Poles"),  py::arg("Weights")
          )
        .def_static("Interpolate_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColStd_Array1OfReal & Parameters, const TColStd_Array1OfInteger & ContactOrderArray, const Standard_Integer ArrayDimension ){
                Standard_Real  Poles;
                Standard_Integer  InversionProblem;

                BSplCLib::Interpolate(Degree,FlatKnots,Parameters,ContactOrderArray,ArrayDimension,Poles,InversionProblem);
                
return std::make_tuple(Poles,InversionProblem); },
            R"#(Performs the interpolation of the data given in the Poles array according to the requests in ContactOrderArray that is : if ContactOrderArray(i) has value d it means that Poles(i) contains the dth derivative of the function to be interpolated. The length L of the following arrays must be the same : Parameters, ContactOrderArray The length of FlatKnots is Degree + L + 1 The PolesArray is an seen as an Array[1..N][1..ArrayDimension] with N = tge length of the parameters array Warning: the method used to do that interpolation is gauss elimination WITHOUT pivoting. Thus if the diagonal is not dominant there is no guarantee that the algorithm will work. Nevertheless for Cubic interpolation or interpolation at Scheonberg points the method will work The InversionProblem will report 0 if there was no problem else it will give the index of the faulty pivot)#"  , py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Parameters"),  py::arg("ContactOrderArray"),  py::arg("ArrayDimension")
          )
        .def_static("Interpolate_s",
            []( const Standard_Integer Degree, const TColStd_Array1OfReal & FlatKnots, const TColStd_Array1OfReal & Parameters, const TColStd_Array1OfInteger & ContactOrderArray, const Standard_Integer ArrayDimension ){
                Standard_Real  Poles;
                Standard_Real  Weights;
                Standard_Integer  InversionProblem;

                BSplCLib::Interpolate(Degree,FlatKnots,Parameters,ContactOrderArray,ArrayDimension,Poles,Weights,InversionProblem);
                
return std::make_tuple(Poles,Weights,InversionProblem); },
            R"#()#"  , py::arg("Degree"),  py::arg("FlatKnots"),  py::arg("Parameters"),  py::arg("ContactOrderArray"),  py::arg("ArrayDimension")
          )
        .def_static("MovePoint_s",
            []( const Standard_Real U, const gp_Vec2d & Displ, const Standard_Integer Index1, const Standard_Integer Index2, const Standard_Integer Degree, const TColgp_Array1OfPnt2d & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & FlatKnots,TColgp_Array1OfPnt2d & NewPoles ){
                Standard_Integer  FirstIndex;
                Standard_Integer  LastIndex;

                BSplCLib::MovePoint(U,Displ,Index1,Index2,Degree,Poles,Weights,FlatKnots,FirstIndex,LastIndex,NewPoles);
                
return std::make_tuple(FirstIndex,LastIndex); },
            R"#(Find the new poles which allows an old point (with a given u as parameter) to reach a new position Index1 and Index2 indicate the range of poles we can move (1, NbPoles-1) or (2, NbPoles) -> no constraint for one side don't enter (1,NbPoles) -> error: rigid move (2, NbPoles-1) -> the ends are enforced (3, NbPoles-2) -> the ends and the tangency are enforced if Problem in BSplineBasis calculation, no change for the curve and FirstIndex, LastIndex = 0)#"  , py::arg("U"),  py::arg("Displ"),  py::arg("Index1"),  py::arg("Index2"),  py::arg("Degree"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("FlatKnots"),  py::arg("NewPoles")
          )
        .def_static("MovePoint_s",
            []( const Standard_Real U, const gp_Vec & Displ, const Standard_Integer Index1, const Standard_Integer Index2, const Standard_Integer Degree, const TColgp_Array1OfPnt & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & FlatKnots,TColgp_Array1OfPnt & NewPoles ){
                Standard_Integer  FirstIndex;
                Standard_Integer  LastIndex;

                BSplCLib::MovePoint(U,Displ,Index1,Index2,Degree,Poles,Weights,FlatKnots,FirstIndex,LastIndex,NewPoles);
                
return std::make_tuple(FirstIndex,LastIndex); },
            R"#(Find the new poles which allows an old point (with a given u as parameter) to reach a new position Index1 and Index2 indicate the range of poles we can move (1, NbPoles-1) or (2, NbPoles) -> no constraint for one side don't enter (1,NbPoles) -> error: rigid move (2, NbPoles-1) -> the ends are enforced (3, NbPoles-2) -> the ends and the tangency are enforced if Problem in BSplineBasis calculation, no change for the curve and FirstIndex, LastIndex = 0)#"  , py::arg("U"),  py::arg("Displ"),  py::arg("Index1"),  py::arg("Index2"),  py::arg("Degree"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("FlatKnots"),  py::arg("NewPoles")
          )
        .def_static("MovePointAndTangent_s",
            []( const Standard_Real U, const Standard_Integer ArrayDimension, const Standard_Real Tolerance, const Standard_Integer Degree, const Standard_Integer StartingCondition, const Standard_Integer EndingCondition, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & FlatKnots ){
                Standard_Real  Delta;
                Standard_Real  DeltaDerivative;
                Standard_Real  Poles;
                Standard_Real  NewPoles;
                Standard_Integer  ErrorStatus;

                BSplCLib::MovePointAndTangent(U,ArrayDimension,Delta,DeltaDerivative,Tolerance,Degree,StartingCondition,EndingCondition,Poles,Weights,FlatKnots,NewPoles,ErrorStatus);
                
return std::make_tuple(Delta,DeltaDerivative,Poles,NewPoles,ErrorStatus); },
            R"#(This is the dimension free version of the utility U is the parameter must be within the first FlatKnots and the last FlatKnots Delta is the amount the curve has to be moved DeltaDerivative is the amount the derivative has to be moved. Delta and DeltaDerivative must be array of dimension ArrayDimension Degree is the degree of the BSpline and the FlatKnots are the knots of the BSpline Starting Condition if = -1 means the starting point of the curve can move = 0 means the starting point of the curve cannot move but tangent starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... Same holds for EndingCondition Poles are the poles of the curve Weights are the weights of the curve if not NULL NewPoles are the poles of the deformed curve ErrorStatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions The way to solve this problem is to add knots to the BSpline If StartCondition = 1 and EndCondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a C1 cubic you will need have at least 2 internal knots.)#"  , py::arg("U"),  py::arg("ArrayDimension"),  py::arg("Tolerance"),  py::arg("Degree"),  py::arg("StartingCondition"),  py::arg("EndingCondition"),  py::arg("Weights"),  py::arg("FlatKnots")
          )
        .def_static("MovePointAndTangent_s",
            []( const Standard_Real U, const gp_Vec & Delta, const gp_Vec & DeltaDerivative, const Standard_Real Tolerance, const Standard_Integer Degree, const Standard_Integer StartingCondition, const Standard_Integer EndingCondition, const TColgp_Array1OfPnt & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & FlatKnots,TColgp_Array1OfPnt & NewPoles ){
                Standard_Integer  ErrorStatus;

                BSplCLib::MovePointAndTangent(U,Delta,DeltaDerivative,Tolerance,Degree,StartingCondition,EndingCondition,Poles,Weights,FlatKnots,NewPoles,ErrorStatus);
                
return std::make_tuple(ErrorStatus); },
            R"#(This is the dimension free version of the utility U is the parameter must be within the first FlatKnots and the last FlatKnots Delta is the amount the curve has to be moved DeltaDerivative is the amount the derivative has to be moved. Delta and DeltaDerivative must be array of dimension ArrayDimension Degree is the degree of the BSpline and the FlatKnots are the knots of the BSpline Starting Condition if = -1 means the starting point of the curve can move = 0 means the starting point of the curve cannot move but tangent starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... Same holds for EndingCondition Poles are the poles of the curve Weights are the weights of the curve if not NULL NewPoles are the poles of the deformed curve ErrorStatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions The way to solve this problem is to add knots to the BSpline If StartCondition = 1 and EndCondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a C1 cubic you will need have at least 2 internal knots.)#"  , py::arg("U"),  py::arg("Delta"),  py::arg("DeltaDerivative"),  py::arg("Tolerance"),  py::arg("Degree"),  py::arg("StartingCondition"),  py::arg("EndingCondition"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("FlatKnots"),  py::arg("NewPoles")
          )
        .def_static("MovePointAndTangent_s",
            []( const Standard_Real U, const gp_Vec2d & Delta, const gp_Vec2d & DeltaDerivative, const Standard_Real Tolerance, const Standard_Integer Degree, const Standard_Integer StartingCondition, const Standard_Integer EndingCondition, const TColgp_Array1OfPnt2d & Poles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & FlatKnots,TColgp_Array1OfPnt2d & NewPoles ){
                Standard_Integer  ErrorStatus;

                BSplCLib::MovePointAndTangent(U,Delta,DeltaDerivative,Tolerance,Degree,StartingCondition,EndingCondition,Poles,Weights,FlatKnots,NewPoles,ErrorStatus);
                
return std::make_tuple(ErrorStatus); },
            R"#(This is the dimension free version of the utility U is the parameter must be within the first FlatKnots and the last FlatKnots Delta is the amount the curve has to be moved DeltaDerivative is the amount the derivative has to be moved. Delta and DeltaDerivative must be array of dimension ArrayDimension Degree is the degree of the BSpline and the FlatKnots are the knots of the BSpline Starting Condition if = -1 means the starting point of the curve can move = 0 means the starting point of the curve cannot move but tangent starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... Same holds for EndingCondition Poles are the poles of the curve Weights are the weights of the curve if not NULL NewPoles are the poles of the deformed curve ErrorStatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions The way to solve this problem is to add knots to the BSpline If StartCondition = 1 and EndCondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a C1 cubic you will need have at least 2 internal knots.)#"  , py::arg("U"),  py::arg("Delta"),  py::arg("DeltaDerivative"),  py::arg("Tolerance"),  py::arg("Degree"),  py::arg("StartingCondition"),  py::arg("EndingCondition"),  py::arg("Poles"),  py::arg("Weights"),  py::arg("FlatKnots"),  py::arg("NewPoles")
          )
        .def_static("Resolution_s",
            []( const Standard_Integer ArrayDimension, const Standard_Integer NumPoles, const TColStd_Array1OfReal * Weights, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer Degree, const Standard_Real Tolerance3D ){
                Standard_Real  PolesArray;
                Standard_Real  UTolerance;

                BSplCLib::Resolution(PolesArray,ArrayDimension,NumPoles,Weights,FlatKnots,Degree,Tolerance3D,UTolerance);
                
return std::make_tuple(PolesArray,UTolerance); },
            R"#(given a tolerance in 3D space returns a tolerance in U parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < UTolerance and we have |f (u1) - f (u0)| < Tolerance3D)#"  , py::arg("ArrayDimension"),  py::arg("NumPoles"),  py::arg("Weights"),  py::arg("FlatKnots"),  py::arg("Degree"),  py::arg("Tolerance3D")
          )
        .def_static("Resolution_s",
            []( const TColgp_Array1OfPnt & Poles, const TColStd_Array1OfReal * Weights, const Standard_Integer NumPoles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer Degree, const Standard_Real Tolerance3D ){
                Standard_Real  UTolerance;

                BSplCLib::Resolution(Poles,Weights,NumPoles,FlatKnots,Degree,Tolerance3D,UTolerance);
                
return std::make_tuple(UTolerance); },
            R"#(given a tolerance in 3D space returns a tolerance in U parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < UTolerance and we have |f (u1) - f (u0)| < Tolerance3D)#"  , py::arg("Poles"),  py::arg("Weights"),  py::arg("NumPoles"),  py::arg("FlatKnots"),  py::arg("Degree"),  py::arg("Tolerance3D")
          )
        .def_static("Resolution_s",
            []( const TColgp_Array1OfPnt2d & Poles, const TColStd_Array1OfReal * Weights, const Standard_Integer NumPoles, const TColStd_Array1OfReal & FlatKnots, const Standard_Integer Degree, const Standard_Real Tolerance3D ){
                Standard_Real  UTolerance;

                BSplCLib::Resolution(Poles,Weights,NumPoles,FlatKnots,Degree,Tolerance3D,UTolerance);
                
return std::make_tuple(UTolerance); },
            R"#(given a tolerance in 3D space returns a tolerance in U parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < UTolerance and we have |f (u1) - f (u0)| < Tolerance3D)#"  , py::arg("Poles"),  py::arg("Weights"),  py::arg("NumPoles"),  py::arg("FlatKnots"),  py::arg("Degree"),  py::arg("Tolerance3D")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BSplCLib_Cache from ./opencascade/BSplCLib_Cache.hxx
    klass = m.attr("BSplCLib_Cache");


    // nested enums

    static_cast<py::class_<BSplCLib_Cache ,opencascade::handle<BSplCLib_Cache>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer &, const Standard_Boolean &, const TColStd_Array1OfReal &, const TColgp_Array1OfPnt2d &, const TColStd_Array1OfReal * >()  , py::arg("theDegree"),  py::arg("thePeriodic"),  py::arg("theFlatKnots"),  py::arg("thePoles2d"),  py::arg("theWeights")=static_cast< const TColStd_Array1OfReal *>(NULL) )
        .def(py::init<  const Standard_Integer &, const Standard_Boolean &, const TColStd_Array1OfReal &, const TColgp_Array1OfPnt &, const TColStd_Array1OfReal * >()  , py::arg("theDegree"),  py::arg("thePeriodic"),  py::arg("theFlatKnots"),  py::arg("thePoles"),  py::arg("theWeights")=static_cast< const TColStd_Array1OfReal *>(NULL) )
    // custom constructors
    // methods
        .def("IsCacheValid",
             (Standard_Boolean (BSplCLib_Cache::*)( Standard_Real  ) const) static_cast<Standard_Boolean (BSplCLib_Cache::*)( Standard_Real  ) const>(&BSplCLib_Cache::IsCacheValid),
             R"#(Verifies validity of the cache using flat parameter of the point)#"  , py::arg("theParameter")
          )
        .def("BuildCache",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal *  ) ) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt2d & ,   const TColStd_Array1OfReal *  ) >(&BSplCLib_Cache::BuildCache),
             R"#(Recomputes the cache data for 2D curves. Does not verify validity of the cache)#"  , py::arg("theParameter"),  py::arg("theFlatKnots"),  py::arg("thePoles2d"),  py::arg("theWeights")
          )
        .def("BuildCache",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal *  ) ) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,   const TColStd_Array1OfReal & ,   const TColgp_Array1OfPnt & ,   const TColStd_Array1OfReal *  ) >(&BSplCLib_Cache::BuildCache),
             R"#(Recomputes the cache data for 3D curves. Does not verify validity of the cache)#"  , py::arg("theParameter"),  py::arg("theFlatKnots"),  py::arg("thePoles"),  py::arg("theWeights")=static_cast< const TColStd_Array1OfReal *>(NULL)
          )
        .def("D0",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d &  ) const>(&BSplCLib_Cache::D0),
             R"#(Calculates the point on the curve in the specified parameter)#"  , py::arg("theParameter"),  py::arg("thePoint")
          )
        .def("D0",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt &  ) const>(&BSplCLib_Cache::D0),
             R"#()#"  , py::arg("theParameter"),  py::arg("thePoint")
          )
        .def("D1",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d & ,  gp_Vec2d &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d & ,  gp_Vec2d &  ) const>(&BSplCLib_Cache::D1),
             R"#(Calculates the point on the curve and its first derivative in the specified parameter)#"  , py::arg("theParameter"),  py::arg("thePoint"),  py::arg("theTangent")
          )
        .def("D1",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt & ,  gp_Vec &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt & ,  gp_Vec &  ) const>(&BSplCLib_Cache::D1),
             R"#()#"  , py::arg("theParameter"),  py::arg("thePoint"),  py::arg("theTangent")
          )
        .def("D2",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&BSplCLib_Cache::D2),
             R"#(Calculates the point on the curve and two derivatives in the specified parameter)#"  , py::arg("theParameter"),  py::arg("thePoint"),  py::arg("theTangent"),  py::arg("theCurvature")
          )
        .def("D2",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const>(&BSplCLib_Cache::D2),
             R"#()#"  , py::arg("theParameter"),  py::arg("thePoint"),  py::arg("theTangent"),  py::arg("theCurvature")
          )
        .def("D3",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&BSplCLib_Cache::D3),
             R"#(Calculates the point on the curve and three derivatives in the specified parameter)#"  , py::arg("theParameter"),  py::arg("thePoint"),  py::arg("theTangent"),  py::arg("theCurvature"),  py::arg("theTorsion")
          )
        .def("D3",
             (void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (BSplCLib_Cache::*)(  const Standard_Real & ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&BSplCLib_Cache::D3),
             R"#()#"  , py::arg("theParameter"),  py::arg("thePoint"),  py::arg("theTangent"),  py::arg("theCurvature"),  py::arg("theTorsion")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BSplCLib_Cache::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BSplCLib_Cache::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BSplCLib_Cache::*)() const) static_cast< const handle<Standard_Type> & (BSplCLib_Cache::*)() const>(&BSplCLib_Cache::DynamicType),
             R"#()#"
             
         )
;

    // Class BSplCLib_CacheParams from ./opencascade/BSplCLib_CacheParams.hxx
    klass = m.attr("BSplCLib_CacheParams");


    // nested enums

    static_cast<py::class_<BSplCLib_CacheParams , shared_ptr<BSplCLib_CacheParams>  >>(klass)
    // constructors
        .def(py::init< Standard_Integer,Standard_Boolean, const TColStd_Array1OfReal & >()  , py::arg("theDegree"),  py::arg("thePeriodic"),  py::arg("theFlatKnots") )
    // custom constructors
    // methods
        .def("PeriodicNormalization",
             (Standard_Real (BSplCLib_CacheParams::*)( Standard_Real  ) const) static_cast<Standard_Real (BSplCLib_CacheParams::*)( Standard_Real  ) const>(&BSplCLib_CacheParams::PeriodicNormalization),
             R"#(Normalizes the parameter for periodic B-splines)#"  , py::arg("theParameter")
          )
        .def("IsCacheValid",
             (Standard_Boolean (BSplCLib_CacheParams::*)( Standard_Real  ) const) static_cast<Standard_Boolean (BSplCLib_CacheParams::*)( Standard_Real  ) const>(&BSplCLib_CacheParams::IsCacheValid),
             R"#(Verifies validity of the cache using flat parameter of the point)#"  , py::arg("theParameter")
          )
    // methods using call by reference i.s.o. return
        .def("LocateParameter",
             []( BSplCLib_CacheParams &self ,  const TColStd_Array1OfReal & theFlatKnots ){
                 Standard_Real  theParameter;

                 self.LocateParameter(theParameter,theFlatKnots);
                 
                 return std::make_tuple(theParameter); },
             R"#(Computes span for the specified parameter)#"  , py::arg("theFlatKnots")
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("SpanStart", &BSplCLib_CacheParams::SpanStart)
        .def_readwrite("SpanLength", &BSplCLib_CacheParams::SpanLength)
        .def_readwrite("SpanIndex", &BSplCLib_CacheParams::SpanIndex)
    // methods returning by ref wrapped as properties
;

    // Class BSplCLib_EvaluatorFunction from ./opencascade/BSplCLib_EvaluatorFunction.hxx
    klass = m.attr("BSplCLib_EvaluatorFunction");


    // nested enums

    static_cast<py::class_<BSplCLib_EvaluatorFunction , shared_ptr<BSplCLib_EvaluatorFunction> ,Py_BSplCLib_EvaluatorFunction >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
        .def("Evaluate",
             []( BSplCLib_EvaluatorFunction &self ,  const Standard_Integer theDerivativeRequest, const Standard_Real * theStartEnd, const Standard_Real theParameter ){
                 Standard_Real  theResult;
                Standard_Integer  theErrorCode;

                 self.Evaluate(theDerivativeRequest,theStartEnd,theParameter,theResult,theErrorCode);
                 
                 return std::make_tuple(theResult,theErrorCode); },
             R"#(Function evaluation method to be defined by descendant)#"  , py::arg("theDerivativeRequest"),  py::arg("theStartEnd"),  py::arg("theParameter")
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
        .def("__call__",
             (void (BSplCLib_EvaluatorFunction::*)(  const Standard_Integer ,   const Standard_Real * ,   const Standard_Real ,  Standard_Real & ,  Standard_Integer &  ) const) static_cast<void (BSplCLib_EvaluatorFunction::*)(  const Standard_Integer ,   const Standard_Real * ,   const Standard_Real ,  Standard_Real & ,  Standard_Integer &  ) const>(&BSplCLib_EvaluatorFunction::operator()),
             py::is_operator(),
             R"#(Shortcut for function-call style usage)#"  , py::arg("theDerivativeRequest"),  py::arg("theStartEnd"),  py::arg("theParameter"),  py::arg("theResult"),  py::arg("theErrorCode")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/BSplCLib.hxx
// ./opencascade/BSplCLib_Cache.hxx
// ./opencascade/BSplCLib_CacheParams.hxx
// ./opencascade/BSplCLib_EvaluatorFunction.hxx
// ./opencascade/BSplCLib_KnotDistribution.hxx
// ./opencascade/BSplCLib_MultDistribution.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
