
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Storage_HeaderData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <FSD_Base64.hxx>
#include <FSD_BinaryFile.hxx>
#include <FSD_BStream.hxx>
#include <FSD_CmpFile.hxx>
#include <FSD_File.hxx>
#include <FSD_FileHeader.hxx>
#include <FSD_FStream.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_FSD_enums(py::module &main_module) {


py::module m = main_module.def_submodule("FSD", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<FSD_Base64 , shared_ptr<FSD_Base64>  >(m,"FSD_Base64",R"#(Tool for encoding/decoding base64 stream.)#");
    py::class_<FSD_FileHeader , shared_ptr<FSD_FileHeader>  >(m,"FSD_FileHeader",R"#()#");
    py::class_<FSD_BinaryFile ,opencascade::handle<FSD_BinaryFile>  , Storage_BaseDriver >(m,"FSD_BinaryFile",R"#()#");
    py::class_<FSD_File ,opencascade::handle<FSD_File>  , Storage_BaseDriver >(m,"FSD_File",R"#(A general driver which defines as a file, the physical container for data to be stored or retrieved.A general driver which defines as a file, the physical container for data to be stored or retrieved.)#");
    py::class_<FSD_CmpFile ,opencascade::handle<FSD_CmpFile>  , FSD_File >(m,"FSD_CmpFile",R"#()#");

};

// user-defined post-inclusion per module

// user-defined post
