
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Storage_BaseDriver.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_AsciiString.hxx>
#include <Storage_Data.hxx>
#include <CDM_Document.hxx>
#include <Message_Messenger.hxx>
#include <Storage_BaseDriver.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_AsciiString.hxx>
#include <Storage_Data.hxx>
#include <CDM_Document.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <CDM_Application.hxx>
#include <PCDM_ReaderFilter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <CDM_MetaData.hxx>
#include <CDM_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_MetaData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <TCollection_ExtendedString.hxx>

// module includes
#include <PCDM.hxx>
#include <PCDM_BaseDriverPointer.hxx>
#include <PCDM_Document.hxx>
#include <PCDM_DOMHeaderParser.hxx>
#include <PCDM_DriverError.hxx>
#include <PCDM_Reader.hxx>
#include <PCDM_ReaderFilter.hxx>
#include <PCDM_ReaderStatus.hxx>
#include <PCDM_ReadWriter.hxx>
#include <PCDM_ReadWriter_1.hxx>
#include <PCDM_Reference.hxx>
#include <PCDM_ReferenceIterator.hxx>
#include <PCDM_RetrievalDriver.hxx>
#include <PCDM_SequenceOfDocument.hxx>
#include <PCDM_SequenceOfReference.hxx>
#include <PCDM_StorageDriver.hxx>
#include <PCDM_StoreStatus.hxx>
#include <PCDM_TypeOfFileDriver.hxx>
#include <PCDM_Writer.hxx>

// template related includes

// ./opencascade/PCDM_SequenceOfDocument.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/PCDM_SequenceOfReference.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_PCDM(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("PCDM"));
py::object klass;

//Python trampoline classes
    class Py_PCDM_ReadWriter : public PCDM_ReadWriter{
    public:
        using PCDM_ReadWriter::PCDM_ReadWriter;


        // public pure virtual
        TCollection_AsciiString Version() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,Version,) };
        void WriteReferenceCounter( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteReferenceCounter,aData,aDocument) };
        void WriteReferences( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument, const TCollection_ExtendedString & theReferencerFileName) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteReferences,aData,aDocument,theReferencerFileName) };
        void WriteExtensions( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteExtensions,aData,aDocument) };
        void WriteVersion( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteVersion,aData,aDocument) };
        Standard_Integer ReadReferenceCounter( const TCollection_ExtendedString & theFileName, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadReferenceCounter,theFileName,theMsgDriver) };
        void ReadReferences( const TCollection_ExtendedString & aFileName,PCDM_SequenceOfReference & theReferences, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadReferences,aFileName,theReferences,theMsgDriver) };
        void ReadExtensions( const TCollection_ExtendedString & aFileName,TColStd_SequenceOfExtendedString & theExtensions, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadExtensions,aFileName,theExtensions,theMsgDriver) };
        Standard_Integer ReadDocumentVersion( const TCollection_ExtendedString & aFileName, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadDocumentVersion,aFileName,theMsgDriver) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_PCDM_Reader : public PCDM_Reader{
    public:
        using PCDM_Reader::PCDM_Reader;


        // public pure virtual
        void Read( const TCollection_ExtendedString & aFileName, const handle<CDM_Document> & aNewDocument, const handle<CDM_Application> & anApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,aFileName,aNewDocument,anApplication,theFilter,theProgress) };
        void Read(Standard_IStream & theIStream, const handle<Storage_Data> & theStorageData, const handle<CDM_Document> & theDoc, const handle<CDM_Application> & theApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,theIStream,theStorageData,theDoc,theApplication,theFilter,theProgress) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_PCDM_Writer : public PCDM_Writer{
    public:
        using PCDM_Writer::PCDM_Writer;


        // public pure virtual
        void Write( const handle<CDM_Document> & aDocument, const TCollection_ExtendedString & aFileName, const Message_ProgressRange & theRange) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Writer,Write,aDocument,aFileName,theRange) };
        void Write( const handle<CDM_Document> & theDocument,Standard_OStream & theOStream, const Message_ProgressRange & theRange) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Writer,Write,theDocument,theOStream,theRange) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_PCDM_RetrievalDriver : public PCDM_RetrievalDriver{
    public:
        using PCDM_RetrievalDriver::PCDM_RetrievalDriver;


        // public pure virtual

        void Read( const TCollection_ExtendedString & aFileName, const handle<CDM_Document> & aNewDocument, const handle<CDM_Application> & anApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,aFileName,aNewDocument,anApplication,theFilter,theProgress) };
        void Read(Standard_IStream & theIStream, const handle<Storage_Data> & theStorageData, const handle<CDM_Document> & theDoc, const handle<CDM_Application> & theApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,theIStream,theStorageData,theDoc,theApplication,theFilter,theProgress) };

        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class PCDM from ./opencascade/PCDM.hxx
    klass = m.attr("PCDM");

    // default constructor
    register_default_constructor<PCDM , shared_ptr<PCDM>>(m,"PCDM");

    // nested enums

    static_cast<py::class_<PCDM , shared_ptr<PCDM>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("FileDriverType_s",
                    (PCDM_TypeOfFileDriver (*)(  const TCollection_AsciiString & ,  handle<Storage_BaseDriver> &  ) ) static_cast<PCDM_TypeOfFileDriver (*)(  const TCollection_AsciiString & ,  handle<Storage_BaseDriver> &  ) >(&PCDM::FileDriverType),
                    R"#()#"  , py::arg("aFileName"),  py::arg("aBaseDriver")
          )
        .def_static("FileDriverType_s",
                    (PCDM_TypeOfFileDriver (*)( Standard_IStream & ,  handle<Storage_BaseDriver> &  ) ) static_cast<PCDM_TypeOfFileDriver (*)( Standard_IStream & ,  handle<Storage_BaseDriver> &  ) >(&PCDM::FileDriverType),
                    R"#()#"  , py::arg("theIStream"),  py::arg("theBaseDriver")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class PCDM_Document from ./opencascade/PCDM_Document.hxx
    klass = m.attr("PCDM_Document");

    // default constructor
    register_default_constructor<PCDM_Document ,opencascade::handle<PCDM_Document>>(m,"PCDM_Document");

    // nested enums

    static_cast<py::class_<PCDM_Document ,opencascade::handle<PCDM_Document>  , Standard_Persistent >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_Document::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_Document::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_Document::*)() const) static_cast< const handle<Standard_Type> & (PCDM_Document::*)() const>(&PCDM_Document::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_ReadWriter from ./opencascade/PCDM_ReadWriter.hxx
    klass = m.attr("PCDM_ReadWriter");


    // nested enums

    static_cast<py::class_<PCDM_ReadWriter ,opencascade::handle<PCDM_ReadWriter> ,Py_PCDM_ReadWriter , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Version",
             (TCollection_AsciiString (PCDM_ReadWriter::*)() const) static_cast<TCollection_AsciiString (PCDM_ReadWriter::*)() const>(&PCDM_ReadWriter::Version),
             R"#(returns PCDM_ReadWriter_1.)#" 
          )
        .def("WriteReferenceCounter",
             (void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const) static_cast<void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const>(&PCDM_ReadWriter::WriteReferenceCounter),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument")
          )
        .def("WriteReferences",
             (void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) const) static_cast<void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) const>(&PCDM_ReadWriter::WriteReferences),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument"),  py::arg("theReferencerFileName")
          )
        .def("WriteExtensions",
             (void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const) static_cast<void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const>(&PCDM_ReadWriter::WriteExtensions),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument")
          )
        .def("WriteVersion",
             (void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const) static_cast<void (PCDM_ReadWriter::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const>(&PCDM_ReadWriter::WriteVersion),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument")
          )
        .def("ReadReferenceCounter",
             (Standard_Integer (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const) static_cast<Standard_Integer (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter::ReadReferenceCounter),
             R"#()#"  , py::arg("theFileName"),  py::arg("theMsgDriver")
          )
        .def("ReadReferences",
             (void (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,  PCDM_SequenceOfReference & ,   const handle<Message_Messenger> &  ) const) static_cast<void (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,  PCDM_SequenceOfReference & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter::ReadReferences),
             R"#()#"  , py::arg("aFileName"),  py::arg("theReferences"),  py::arg("theMsgDriver")
          )
        .def("ReadExtensions",
             (void (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,  TColStd_SequenceOfExtendedString & ,   const handle<Message_Messenger> &  ) const) static_cast<void (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,  TColStd_SequenceOfExtendedString & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter::ReadExtensions),
             R"#()#"  , py::arg("aFileName"),  py::arg("theExtensions"),  py::arg("theMsgDriver")
          )
        .def("ReadDocumentVersion",
             (Standard_Integer (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const) static_cast<Standard_Integer (PCDM_ReadWriter::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter::ReadDocumentVersion),
             R"#()#"  , py::arg("aFileName"),  py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Open_s",
                    (void (*)(  const handle<Storage_BaseDriver> & ,   const TCollection_ExtendedString & ,   const Storage_OpenMode  ) ) static_cast<void (*)(  const handle<Storage_BaseDriver> & ,   const TCollection_ExtendedString & ,   const Storage_OpenMode  ) >(&PCDM_ReadWriter::Open),
                    R"#()#"  , py::arg("aDriver"),  py::arg("aFileName"),  py::arg("anOpenMode")
          )
        .def_static("Reader_s",
                    (handle<PCDM_ReadWriter> (*)(  const TCollection_ExtendedString &  ) ) static_cast<handle<PCDM_ReadWriter> (*)(  const TCollection_ExtendedString &  ) >(&PCDM_ReadWriter::Reader),
                    R"#(returns the convenient Reader for a File.)#"  , py::arg("aFileName")
          )
        .def_static("Writer_s",
                    (handle<PCDM_ReadWriter> (*)() ) static_cast<handle<PCDM_ReadWriter> (*)() >(&PCDM_ReadWriter::Writer),
                    R"#()#" 
          )
        .def_static("WriteFileFormat_s",
                    (void (*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) ) static_cast<void (*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) >(&PCDM_ReadWriter::WriteFileFormat),
                    R"#()#"  , py::arg("aData"),  py::arg("aDocument")
          )
        .def_static("FileFormat_s",
                    (TCollection_ExtendedString (*)(  const TCollection_ExtendedString &  ) ) static_cast<TCollection_ExtendedString (*)(  const TCollection_ExtendedString &  ) >(&PCDM_ReadWriter::FileFormat),
                    R"#(tries to get a format in the file. returns an empty string if the file could not be read or does not have a FileFormat information.)#"  , py::arg("aFileName")
          )
        .def_static("FileFormat_s",
                    (TCollection_ExtendedString (*)( Standard_IStream & ,  handle<Storage_Data> &  ) ) static_cast<TCollection_ExtendedString (*)( Standard_IStream & ,  handle<Storage_Data> &  ) >(&PCDM_ReadWriter::FileFormat),
                    R"#(tries to get a format from the stream. returns an empty string if the file could not be read or does not have a FileFormat information.)#"  , py::arg("theIStream"),  py::arg("theData")
          )
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_ReadWriter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_ReadWriter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_ReadWriter::*)() const) static_cast< const handle<Standard_Type> & (PCDM_ReadWriter::*)() const>(&PCDM_ReadWriter::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_Reader from ./opencascade/PCDM_Reader.hxx
    klass = m.attr("PCDM_Reader");


    // nested enums

    static_cast<py::class_<PCDM_Reader ,opencascade::handle<PCDM_Reader> ,Py_PCDM_Reader , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Read",
             (void (PCDM_Reader::*)(  const TCollection_ExtendedString & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) ) static_cast<void (PCDM_Reader::*)(  const TCollection_ExtendedString & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) >(&PCDM_Reader::Read),
             R"#(retrieves the content of the file into a new Document.)#"  , py::arg("aFileName"),  py::arg("aNewDocument"),  py::arg("anApplication"),  py::arg("theFilter")=static_cast< const handle<PCDM_ReaderFilter> &>(Handle ( PCDM_ReaderFilter ) ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (PCDM_Reader::*)( Standard_IStream & ,   const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) ) static_cast<void (PCDM_Reader::*)( Standard_IStream & ,   const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) >(&PCDM_Reader::Read),
             R"#()#"  , py::arg("theIStream"),  py::arg("theStorageData"),  py::arg("theDoc"),  py::arg("theApplication"),  py::arg("theFilter")=static_cast< const handle<PCDM_ReaderFilter> &>(Handle ( PCDM_ReaderFilter ) ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("GetStatus",
             (PCDM_ReaderStatus (PCDM_Reader::*)() const) static_cast<PCDM_ReaderStatus (PCDM_Reader::*)() const>(&PCDM_Reader::GetStatus),
             R"#()#" 
          )
        .def("GetStatus",
             (PCDM_ReaderStatus (PCDM_Reader::*)() const) static_cast<PCDM_ReaderStatus (PCDM_Reader::*)() const>(&PCDM_Reader::GetStatus),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_Reader::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_Reader::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_Reader::*)() const) static_cast< const handle<Standard_Type> & (PCDM_Reader::*)() const>(&PCDM_Reader::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_ReaderFilter from ./opencascade/PCDM_ReaderFilter.hxx
    klass = m.attr("PCDM_ReaderFilter");


    // nested enums
        py::enum_<PCDM_ReaderFilter::AppendMode>(klass, "AppendMode_e", R"#(Supported modes of appending the file content into existing document)#")
            .value("AppendMode_Forbid", PCDM_ReaderFilter::AppendMode::AppendMode_Forbid)
            .value("AppendMode_Protect", PCDM_ReaderFilter::AppendMode::AppendMode_Protect)
            .value("AppendMode_Overwrite", PCDM_ReaderFilter::AppendMode::AppendMode_Overwrite).export_values();

    static_cast<py::class_<PCDM_ReaderFilter ,opencascade::handle<PCDM_ReaderFilter>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<Standard_Type> & >()  , py::arg("theSkipped") )
        .def(py::init<  const TCollection_AsciiString & >()  , py::arg("theEntryToRead") )
        .def(py::init<  const PCDM_ReaderFilter::AppendMode >()  , py::arg("theAppend") )
    // custom constructors
    // methods
        .def("AddSkipped",
             (void (PCDM_ReaderFilter::*)(  const handle<Standard_Type> &  ) ) static_cast<void (PCDM_ReaderFilter::*)(  const handle<Standard_Type> &  ) >(&PCDM_ReaderFilter::AddSkipped),
             R"#(Adds skipped attribute by type.)#"  , py::arg("theSkipped")
          )
        .def("AddSkipped",
             (void (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) ) static_cast<void (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) >(&PCDM_ReaderFilter::AddSkipped),
             R"#(Adds skipped attribute by type name.)#"  , py::arg("theSkipped")
          )
        .def("AddRead",
             (void (PCDM_ReaderFilter::*)(  const handle<Standard_Type> &  ) ) static_cast<void (PCDM_ReaderFilter::*)(  const handle<Standard_Type> &  ) >(&PCDM_ReaderFilter::AddRead),
             R"#(Adds attribute to read by type. Disables the skipped attributes added.)#"  , py::arg("theRead")
          )
        .def("AddRead",
             (void (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) ) static_cast<void (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) >(&PCDM_ReaderFilter::AddRead),
             R"#(Adds attribute to read by type name. Disables the skipped attributes added.)#"  , py::arg("theRead")
          )
        .def("AddPath",
             (void (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) ) static_cast<void (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) >(&PCDM_ReaderFilter::AddPath),
             R"#(Adds sub-tree path (like "0:2").)#"  , py::arg("theEntryToRead")
          )
        .def("Clear",
             (void (PCDM_ReaderFilter::*)() ) static_cast<void (PCDM_ReaderFilter::*)() >(&PCDM_ReaderFilter::Clear),
             R"#(Makes filter pass all data.)#" 
          )
        .def("IsPassed",
             (Standard_Boolean (PCDM_ReaderFilter::*)(  const handle<Standard_Type> &  ) const) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)(  const handle<Standard_Type> &  ) const>(&PCDM_ReaderFilter::IsPassed),
             R"#(Returns true if attribute must be read.)#"  , py::arg("theAttributeID")
          )
        .def("IsPassedAttr",
             (Standard_Boolean (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) const>(&PCDM_ReaderFilter::IsPassedAttr),
             R"#(Returns true if attribute must be read.)#"  , py::arg("theAttributeType")
          )
        .def("IsPassed",
             (Standard_Boolean (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) const>(&PCDM_ReaderFilter::IsPassed),
             R"#(Returns true if content of the label must be read.)#"  , py::arg("theEntry")
          )
        .def("IsSubPassed",
             (Standard_Boolean (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)(  const TCollection_AsciiString &  ) const>(&PCDM_ReaderFilter::IsSubPassed),
             R"#(Returns true if some sub-label of the given label is passed.)#"  , py::arg("theEntry")
          )
        .def("IsPartTree",
             (Standard_Boolean (PCDM_ReaderFilter::*)() ) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)() >(&PCDM_ReaderFilter::IsPartTree),
             R"#(Returns true if only part of the document tree will be retrieved.)#" 
          )
        .def("IsAppendMode",
             (Standard_Boolean (PCDM_ReaderFilter::*)() ) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)() >(&PCDM_ReaderFilter::IsAppendMode),
             R"#(Returns true if appending to the document is performed.)#" 
          )
        .def("StartIteration",
             (void (PCDM_ReaderFilter::*)() ) static_cast<void (PCDM_ReaderFilter::*)() >(&PCDM_ReaderFilter::StartIteration),
             R"#(Starts the tree iterator. It is used for fast searching of passed labels if the whole tree of labels is parsed. So, on each iteration step the methods Up and Down must be called after the iteration start.)#" 
          )
        .def("Up",
             (void (PCDM_ReaderFilter::*)() ) static_cast<void (PCDM_ReaderFilter::*)() >(&PCDM_ReaderFilter::Up),
             R"#(Iteration to the child label.)#" 
          )
        .def("Down",
             (void (PCDM_ReaderFilter::*)(  const int &  ) ) static_cast<void (PCDM_ReaderFilter::*)(  const int &  ) >(&PCDM_ReaderFilter::Down),
             R"#(Iteration to the child with defined tag.)#"  , py::arg("theTag")
          )
        .def("IsPassed",
             (Standard_Boolean (PCDM_ReaderFilter::*)() const) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)() const>(&PCDM_ReaderFilter::IsPassed),
             R"#(Returns true if content of the currently iterated label must be read.)#" 
          )
        .def("IsSubPassed",
             (Standard_Boolean (PCDM_ReaderFilter::*)() const) static_cast<Standard_Boolean (PCDM_ReaderFilter::*)() const>(&PCDM_ReaderFilter::IsSubPassed),
             R"#(Returns true if some sub-label of the currently iterated label is passed.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_ReaderFilter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_ReaderFilter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Mode",
             (PCDM_ReaderFilter::AppendMode & (PCDM_ReaderFilter::*)() ) static_cast<PCDM_ReaderFilter::AppendMode & (PCDM_ReaderFilter::*)() >(&PCDM_ReaderFilter::Mode),
             R"#(Returns the append mode.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_ReaderFilter::*)() const) static_cast< const handle<Standard_Type> & (PCDM_ReaderFilter::*)() const>(&PCDM_ReaderFilter::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_Reference from ./opencascade/PCDM_Reference.hxx
    klass = m.attr("PCDM_Reference");


    // nested enums

    static_cast<py::class_<PCDM_Reference , shared_ptr<PCDM_Reference>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Integer, const TCollection_ExtendedString &, const Standard_Integer >()  , py::arg("aReferenceIdentifier"),  py::arg("aFileName"),  py::arg("aDocumentVersion") )
    // custom constructors
    // methods
        .def("ReferenceIdentifier",
             (Standard_Integer (PCDM_Reference::*)() const) static_cast<Standard_Integer (PCDM_Reference::*)() const>(&PCDM_Reference::ReferenceIdentifier),
             R"#()#" 
          )
        .def("FileName",
             (TCollection_ExtendedString (PCDM_Reference::*)() const) static_cast<TCollection_ExtendedString (PCDM_Reference::*)() const>(&PCDM_Reference::FileName),
             R"#()#" 
          )
        .def("DocumentVersion",
             (Standard_Integer (PCDM_Reference::*)() const) static_cast<Standard_Integer (PCDM_Reference::*)() const>(&PCDM_Reference::DocumentVersion),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class PCDM_ReferenceIterator from ./opencascade/PCDM_ReferenceIterator.hxx
    klass = m.attr("PCDM_ReferenceIterator");


    // nested enums

    static_cast<py::class_<PCDM_ReferenceIterator ,opencascade::handle<PCDM_ReferenceIterator>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("LoadReferences",
             (void (PCDM_ReferenceIterator::*)(  const handle<CDM_Document> & ,   const handle<CDM_MetaData> & ,   const handle<CDM_Application> & ,   const Standard_Boolean  ) ) static_cast<void (PCDM_ReferenceIterator::*)(  const handle<CDM_Document> & ,   const handle<CDM_MetaData> & ,   const handle<CDM_Application> & ,   const Standard_Boolean  ) >(&PCDM_ReferenceIterator::LoadReferences),
             R"#()#"  , py::arg("aDocument"),  py::arg("aMetaData"),  py::arg("anApplication"),  py::arg("UseStorageConfiguration")
          )
        .def("Init",
             (void (PCDM_ReferenceIterator::*)(  const handle<CDM_MetaData> &  ) ) static_cast<void (PCDM_ReferenceIterator::*)(  const handle<CDM_MetaData> &  ) >(&PCDM_ReferenceIterator::Init),
             R"#()#"  , py::arg("aMetaData")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_ReferenceIterator::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_ReferenceIterator::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_ReferenceIterator::*)() const) static_cast< const handle<Standard_Type> & (PCDM_ReferenceIterator::*)() const>(&PCDM_ReferenceIterator::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_Writer from ./opencascade/PCDM_Writer.hxx
    klass = m.attr("PCDM_Writer");


    // nested enums

    static_cast<py::class_<PCDM_Writer ,opencascade::handle<PCDM_Writer> ,Py_PCDM_Writer , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Write",
             (void (PCDM_Writer::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString & ,   const Message_ProgressRange &  ) ) static_cast<void (PCDM_Writer::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString & ,   const Message_ProgressRange &  ) >(&PCDM_Writer::Write),
             R"#()#"  , py::arg("aDocument"),  py::arg("aFileName"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (void (PCDM_Writer::*)(  const handle<CDM_Document> & ,  Standard_OStream & ,   const Message_ProgressRange &  ) ) static_cast<void (PCDM_Writer::*)(  const handle<CDM_Document> & ,  Standard_OStream & ,   const Message_ProgressRange &  ) >(&PCDM_Writer::Write),
             R"#(Write <theDocument> to theOStream)#"  , py::arg("theDocument"),  py::arg("theOStream"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_Writer::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_Writer::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_Writer::*)() const) static_cast< const handle<Standard_Type> & (PCDM_Writer::*)() const>(&PCDM_Writer::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_ReadWriter_1 from ./opencascade/PCDM_ReadWriter_1.hxx
    klass = m.attr("PCDM_ReadWriter_1");


    // nested enums

    static_cast<py::class_<PCDM_ReadWriter_1 ,opencascade::handle<PCDM_ReadWriter_1>  , PCDM_ReadWriter >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Version",
             (TCollection_AsciiString (PCDM_ReadWriter_1::*)() const) static_cast<TCollection_AsciiString (PCDM_ReadWriter_1::*)() const>(&PCDM_ReadWriter_1::Version),
             R"#(returns PCDM_ReadWriter_1.)#" 
          )
        .def("WriteReferenceCounter",
             (void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const) static_cast<void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const>(&PCDM_ReadWriter_1::WriteReferenceCounter),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument")
          )
        .def("WriteReferences",
             (void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) const) static_cast<void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) const>(&PCDM_ReadWriter_1::WriteReferences),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument"),  py::arg("theReferencerFileName")
          )
        .def("WriteExtensions",
             (void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const) static_cast<void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const>(&PCDM_ReadWriter_1::WriteExtensions),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument")
          )
        .def("WriteVersion",
             (void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const) static_cast<void (PCDM_ReadWriter_1::*)(  const handle<Storage_Data> & ,   const handle<CDM_Document> &  ) const>(&PCDM_ReadWriter_1::WriteVersion),
             R"#()#"  , py::arg("aData"),  py::arg("aDocument")
          )
        .def("ReadReferenceCounter",
             (Standard_Integer (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const) static_cast<Standard_Integer (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter_1::ReadReferenceCounter),
             R"#()#"  , py::arg("aFileName"),  py::arg("theMsgDriver")
          )
        .def("ReadReferences",
             (void (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,  PCDM_SequenceOfReference & ,   const handle<Message_Messenger> &  ) const) static_cast<void (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,  PCDM_SequenceOfReference & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter_1::ReadReferences),
             R"#()#"  , py::arg("aFileName"),  py::arg("theReferences"),  py::arg("theMsgDriver")
          )
        .def("ReadExtensions",
             (void (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,  TColStd_SequenceOfExtendedString & ,   const handle<Message_Messenger> &  ) const) static_cast<void (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,  TColStd_SequenceOfExtendedString & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter_1::ReadExtensions),
             R"#()#"  , py::arg("aFileName"),  py::arg("theExtensions"),  py::arg("theMsgDriver")
          )
        .def("ReadDocumentVersion",
             (Standard_Integer (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const) static_cast<Standard_Integer (PCDM_ReadWriter_1::*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) const>(&PCDM_ReadWriter_1::ReadDocumentVersion),
             R"#()#"  , py::arg("aFileName"),  py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_ReadWriter_1::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_ReadWriter_1::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_ReadWriter_1::*)() const) static_cast< const handle<Standard_Type> & (PCDM_ReadWriter_1::*)() const>(&PCDM_ReadWriter_1::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_RetrievalDriver from ./opencascade/PCDM_RetrievalDriver.hxx
    klass = m.attr("PCDM_RetrievalDriver");


    // nested enums

    static_cast<py::class_<PCDM_RetrievalDriver ,opencascade::handle<PCDM_RetrievalDriver> ,Py_PCDM_RetrievalDriver , PCDM_Reader >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("SetFormat",
             (void (PCDM_RetrievalDriver::*)(  const TCollection_ExtendedString &  ) ) static_cast<void (PCDM_RetrievalDriver::*)(  const TCollection_ExtendedString &  ) >(&PCDM_RetrievalDriver::SetFormat),
             R"#()#"  , py::arg("aformat")
          )
        .def("GetFormat",
             (TCollection_ExtendedString (PCDM_RetrievalDriver::*)() const) static_cast<TCollection_ExtendedString (PCDM_RetrievalDriver::*)() const>(&PCDM_RetrievalDriver::GetFormat),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DocumentVersion_s",
                    (Standard_Integer (*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) ) static_cast<Standard_Integer (*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) >(&PCDM_RetrievalDriver::DocumentVersion),
                    R"#()#"  , py::arg("theFileName"),  py::arg("theMsgDriver")
          )
        .def_static("ReferenceCounter_s",
                    (Standard_Integer (*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) ) static_cast<Standard_Integer (*)(  const TCollection_ExtendedString & ,   const handle<Message_Messenger> &  ) >(&PCDM_RetrievalDriver::ReferenceCounter),
                    R"#()#"  , py::arg("theFileName"),  py::arg("theMsgDriver")
          )
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_RetrievalDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_RetrievalDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_RetrievalDriver::*)() const) static_cast< const handle<Standard_Type> & (PCDM_RetrievalDriver::*)() const>(&PCDM_RetrievalDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class PCDM_StorageDriver from ./opencascade/PCDM_StorageDriver.hxx
    klass = m.attr("PCDM_StorageDriver");

    // default constructor
    register_default_constructor<PCDM_StorageDriver ,opencascade::handle<PCDM_StorageDriver>>(m,"PCDM_StorageDriver");

    // nested enums

    static_cast<py::class_<PCDM_StorageDriver ,opencascade::handle<PCDM_StorageDriver>  , PCDM_Writer >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Make",
             (handle<PCDM_Document> (PCDM_StorageDriver::*)(  const handle<CDM_Document> &  ) ) static_cast<handle<PCDM_Document> (PCDM_StorageDriver::*)(  const handle<CDM_Document> &  ) >(&PCDM_StorageDriver::Make),
             R"#(raises NotImplemented.)#"  , py::arg("aDocument")
          )
        .def("Make",
             (void (PCDM_StorageDriver::*)(  const handle<CDM_Document> & ,  PCDM_SequenceOfDocument &  ) ) static_cast<void (PCDM_StorageDriver::*)(  const handle<CDM_Document> & ,  PCDM_SequenceOfDocument &  ) >(&PCDM_StorageDriver::Make),
             R"#(By default, puts in the Sequence the document returns by the previous Make method.)#"  , py::arg("aDocument"),  py::arg("Documents")
          )
        .def("Write",
             (void (PCDM_StorageDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString & ,   const Message_ProgressRange &  ) ) static_cast<void (PCDM_StorageDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString & ,   const Message_ProgressRange &  ) >(&PCDM_StorageDriver::Write),
             R"#(Warning! raises DriverError if an error occurs during inside the Make method. stores the content of the Document into a new file.)#"  , py::arg("aDocument"),  py::arg("aFileName"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (void (PCDM_StorageDriver::*)(  const handle<CDM_Document> & ,  Standard_OStream & ,   const Message_ProgressRange &  ) ) static_cast<void (PCDM_StorageDriver::*)(  const handle<CDM_Document> & ,  Standard_OStream & ,   const Message_ProgressRange &  ) >(&PCDM_StorageDriver::Write),
             R"#(Write <theDocument> to theOStream)#"  , py::arg("theDocument"),  py::arg("theOStream"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("SetFormat",
             (void (PCDM_StorageDriver::*)(  const TCollection_ExtendedString &  ) ) static_cast<void (PCDM_StorageDriver::*)(  const TCollection_ExtendedString &  ) >(&PCDM_StorageDriver::SetFormat),
             R"#()#"  , py::arg("aformat")
          )
        .def("GetFormat",
             (TCollection_ExtendedString (PCDM_StorageDriver::*)() const) static_cast<TCollection_ExtendedString (PCDM_StorageDriver::*)() const>(&PCDM_StorageDriver::GetFormat),
             R"#()#" 
          )
        .def("IsError",
             (Standard_Boolean (PCDM_StorageDriver::*)() const) static_cast<Standard_Boolean (PCDM_StorageDriver::*)() const>(&PCDM_StorageDriver::IsError),
             R"#()#" 
          )
        .def("SetIsError",
             (void (PCDM_StorageDriver::*)(  const Standard_Boolean  ) ) static_cast<void (PCDM_StorageDriver::*)(  const Standard_Boolean  ) >(&PCDM_StorageDriver::SetIsError),
             R"#()#"  , py::arg("theIsError")
          )
        .def("GetStoreStatus",
             (PCDM_StoreStatus (PCDM_StorageDriver::*)() const) static_cast<PCDM_StoreStatus (PCDM_StorageDriver::*)() const>(&PCDM_StorageDriver::GetStoreStatus),
             R"#()#" 
          )
        .def("SetStoreStatus",
             (void (PCDM_StorageDriver::*)(  const PCDM_StoreStatus  ) ) static_cast<void (PCDM_StorageDriver::*)(  const PCDM_StoreStatus  ) >(&PCDM_StorageDriver::SetStoreStatus),
             R"#()#"  , py::arg("theStoreStatus")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&PCDM_StorageDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&PCDM_StorageDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (PCDM_StorageDriver::*)() const) static_cast< const handle<Standard_Type> & (PCDM_StorageDriver::*)() const>(&PCDM_StorageDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/PCDM.hxx
// ./opencascade/PCDM_BaseDriverPointer.hxx
// ./opencascade/PCDM_DOMHeaderParser.hxx
// ./opencascade/PCDM_Document.hxx
// ./opencascade/PCDM_DriverError.hxx
// ./opencascade/PCDM_ReadWriter.hxx
// ./opencascade/PCDM_ReadWriter_1.hxx
// ./opencascade/PCDM_Reader.hxx
// ./opencascade/PCDM_ReaderFilter.hxx
// ./opencascade/PCDM_ReaderStatus.hxx
// ./opencascade/PCDM_Reference.hxx
// ./opencascade/PCDM_ReferenceIterator.hxx
// ./opencascade/PCDM_RetrievalDriver.hxx
// ./opencascade/PCDM_SequenceOfDocument.hxx
// ./opencascade/PCDM_SequenceOfReference.hxx
// ./opencascade/PCDM_StorageDriver.hxx
// ./opencascade/PCDM_StoreStatus.hxx
// ./opencascade/PCDM_TypeOfFileDriver.hxx
// ./opencascade/PCDM_Writer.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_Sequence<opencascade::handle<PCDM_Document>>(m,"PCDM_SequenceOfDocument");
    register_template_NCollection_Sequence<PCDM_Reference>(m,"PCDM_SequenceOfReference");


// exceptions
register_occ_exception<PCDM_DriverError>(m, "PCDM_DriverError");

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
