% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_slide_manip.R
\name{remove_slide}
\alias{remove_slide}
\title{Remove slide(s)}
\usage{
remove_slide(x, index = NULL, rm_images = FALSE)
}
\arguments{
\item{x}{an rpptx object}

\item{index}{slide index or a vector of slide indices to remove,
default to current slide position.}

\item{rm_images}{unused anymore.}
}
\description{
Remove one or more slides from a pptx presentation.
}
\note{
cursor is set on the last slide.
}
\examples{
library(officer)

x <- read_pptx()
x <- add_slide(x, "Title and Content")
x <- remove_slide(x)

# Remove multiple slides at once
x <- read_pptx()
x <- add_slide(x, "Title and Content")
x <- add_slide(
  x,
  layout = "Two Content",
  `Title 1` = "A title",
  dt = "Jan. 26, 2025",
  `body[2]` = "Body 2",
  left = "Left side",
  `6` = "Footer"
)
x <- add_slide(
  x,
  layout = "Two Content",
  `Title 1` = "A title",
  dt = "Jan. 26, 2025",
  `body[2]` = "Body 2",
  left = "Left side",
  `6` = "Footer"
)
x <- add_slide(x, "Title and Content")
x <- remove_slide(x, index = c(2, 4))
pptx_file <- print(x, target = tempfile(fileext = ".pptx"))
pptx_file
}
\seealso{
\code{\link[=read_pptx]{read_pptx()}}, \code{\link[=ph_with]{ph_with()}}, \code{\link[=ph_remove]{ph_remove()}}

Other functions to manipulate slides:
\code{\link{add_slide}()},
\code{\link{move_slide}()},
\code{\link{on_slide}()},
\code{\link{set_notes}()}
}
\concept{slide_manipulation}
