The release notes provide a summary of notable changes since the previous ROCm release.

- [Release highlights](release-highlights)

- [Operating system and hardware support changes](operating-system-and-hardware-support-changes)

- [ROCm components versioning](rocm-components)

- [Detailed component changes](detailed-component-changes)

- [ROCm known issues](rocm-known-issues)

- [ROCm upcoming changes](rocm-upcoming-changes)

The [Compatibility matrix](https://rocm.docs.amd.com/en/docs-6.2.1/compatibility/compatibility-matrix.html)
provides the full list of supported hardware, operating systems, ecosystems, third-party components, and ROCm components for each ROCm release.

Release notes for previous ROCm releases are available in earlier versions of the documentation.
See the [ROCm documentation release history](https://rocm.docs.amd.com/en/latest/release/versions.html).

## Release highlights

The following are notable new features and improvements in ROCm 6.2.1. For changes to individual components, see [Detailed component changes](#detailed-component-changes).

### rocAL major version change

The new version of rocAL introduces many new features, but does not modify any of the existing public API functions. However, the version number was incremented from 1.3 to 2.0.
Applications linked to version 1.3 must be recompiled to link against version 2.0.

See [the rocAL detailed changes](#rocal-2-0-0) for more information.

### New support for FBGEMM (Facebook General Matrix Multiplication)

As of ROCm 6.2.1, ROCm supports Facebook General Matrix Multiplication (FBGEMM) and the related FBGEMM_GPU library. 

FBGEMM is a low-precision, high-performance CPU kernel library for convolution and matrix multiplication. It is used for server-side inference and as a back end for PyTorch quantized operators. FBGEMM_GPU includes a collection of PyTorch GPU operator libraries for training and inference. For more information, see the ROCm [Model acceleration libraries guide](https://rocm.docs.amd.com/en/docs-6.2.1/how-to/llm-fine-tuning-optimization/model-acceleration-libraries.html)
and [PyTorch's FBGEMM GitHub repository](https://github.com/pytorch/FBGEMM).

### ROCm Offline Installer Creator changes

The [ROCm Offline Installer Creator 6.2.1](https://rocm.docs.amd.com/projects/install-on-linux/en/docs-6.2.1/install/rocm-offline-installer.html) introduces several new features and improvements including:

* Logging support for create and install logs
* More stringent checks for Linux versions and distributions
* Updated prerequisite repositories
* Fixed CTest issues

### ROCm documentation changes 

There have been no changes to supported hardware or operating systems from ROCm 6.2.0 to ROCm 6.2.1.

* The Programming Model Reference and Understanding the Programming Model topics in HIP have been consolidated into one topic,
[HIP programming model (conceptual)](https://rocm.docs.amd.com/projects/HIP/en/docs-6.2.1/understand/programming_model.html). 
* The [HIP virtual memory management](https://rocm.docs.amd.com/projects/HIP/en/docs-6.2.1/how-to/virtual_memory.html) and [HIP virtual memory management API](https://rocm.docs.amd.com/projects/HIP/en/docs-6.2.1/reference/virtual_memory_reference.html) topics have been added.

```{note}
The ROCm documentation, like all ROCm projects, is open source and available on GitHub. To contribute to ROCm documentation, see the [ROCm documentation contribution guidelines](https://rocm.docs.amd.com/en/latest/contribute/contributing.html).
```
