// Copyright 2017 Open Source Robotics Foundation, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "ament_index_cpp/get_packages_with_prefixes.hpp"

#include <map>
#include <string>

#include "ament_index_cpp/get_resources.hpp"

namespace ament_index_cpp
{

std::map<std::string, std::string>
get_packages_with_prefixes()
{
  std::map<std::string, std::string> result;
  std::map<std::string, std::filesystem::path> resources = get_resources_by_name("packages");
  for (const auto & resource : resources) {
    result[resource.first] = resource.second.string();
  }
  return result;
}

}  // namespace ament_index_cpp
