# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `ffi` gem.
# Please instead update this file by running `bin/tapioca gem ffi`.

# source://ffi//lib/ffi/platform.rb#32
module FFI
  class << self
    # Add a definition type to type definitions.
    #
    # @param old [Type, DataConverter, Symbol] type definition used by {FFI.find_type}
    # @param add [Symbol] new type definition's name to add
    # @return [Type]
    #
    # source://ffi//lib/ffi/types.rb#45
    def add_typedef(old, add); end

    # @see FFI::LastError.error
    #
    # source://ffi//lib/ffi/errno.rb#34
    def errno; end

    # @see FFI::LastError.error=
    #
    # source://ffi//lib/ffi/errno.rb#40
    def errno=(error); end

    # Find a type in +type_map+ ({FFI::TypeDefs}, by default) from
    # a type objet, a type name (symbol). If +name+ is a {DataConverter},
    # a new {Type::Mapped} is created.
    #
    # @param name [Type, DataConverter, Symbol]
    # @param type_map [Hash] if nil, {FFI::TypeDefs} is used
    # @return [Type]
    #
    # source://ffi//lib/ffi/types.rb#56
    def find_type(name, type_map = T.unsafe(nil)); end

    # Transform a generic library name to a platform library name
    #
    # @example
    #   # Linux
    #   FFI.map_library_name 'c'     # -> "libc.so.6"
    #   FFI.map_library_name 'jpeg'  # -> "libjpeg.so"
    #   # Windows
    #   FFI.map_library_name 'c'     # -> "msvcrt.dll"
    #   FFI.map_library_name 'jpeg'  # -> "jpeg.dll"
    # @param lib [#to_s] library name
    # @return [String] library name formatted for current platform
    #
    # source://ffi//lib/ffi/library.rb#44
    def map_library_name(lib); end

    # Get +type+ size, in bytes.
    #
    # @param type +type+ is an instance of class accepted by {FFI.find_type}
    # @return [Numeric]
    #
    # source://ffi//lib/ffi/types.rb#176
    def type_size(type); end

    # Add a definition type to type definitions.
    #
    # @param old [Type, DataConverter, Symbol] type definition used by {FFI.find_type}
    # @param add [Symbol] new type definition's name to add
    # @return [Type]
    #
    # source://ffi//lib/ffi/types.rb#40
    def typedef(old, add); end
  end
end

# source://ffi//lib/ffi/abstract_memory.rb#33
class FFI::AbstractMemory
  def [](_arg0); end
  def __copy_from__(_arg0, _arg1); end
  def clear; end
  def get(_arg0, _arg1); end
  def get_array_of_char(_arg0, _arg1); end
  def get_array_of_double(_arg0, _arg1); end
  def get_array_of_float(_arg0, _arg1); end
  def get_array_of_float32(_arg0, _arg1); end
  def get_array_of_float64(_arg0, _arg1); end
  def get_array_of_int(_arg0, _arg1); end
  def get_array_of_int16(_arg0, _arg1); end
  def get_array_of_int32(_arg0, _arg1); end
  def get_array_of_int64(_arg0, _arg1); end
  def get_array_of_int8(_arg0, _arg1); end
  def get_array_of_long(_arg0, _arg1); end
  def get_array_of_long_long(_arg0, _arg1); end
  def get_array_of_pointer(_arg0, _arg1); end
  def get_array_of_short(_arg0, _arg1); end
  def get_array_of_string(*_arg0); end
  def get_array_of_uchar(_arg0, _arg1); end
  def get_array_of_uint(_arg0, _arg1); end
  def get_array_of_uint16(_arg0, _arg1); end
  def get_array_of_uint32(_arg0, _arg1); end
  def get_array_of_uint64(_arg0, _arg1); end
  def get_array_of_uint8(_arg0, _arg1); end
  def get_array_of_ulong(_arg0, _arg1); end
  def get_array_of_ulong_long(_arg0, _arg1); end
  def get_array_of_ushort(_arg0, _arg1); end
  def get_bytes(_arg0, _arg1); end
  def get_char(_arg0); end
  def get_double(_arg0); end
  def get_float(_arg0); end
  def get_float32(_arg0); end
  def get_float64(_arg0); end
  def get_int(_arg0); end
  def get_int16(_arg0); end
  def get_int32(_arg0); end
  def get_int64(_arg0); end
  def get_int8(_arg0); end
  def get_long(_arg0); end
  def get_long_long(_arg0); end
  def get_pointer(_arg0); end
  def get_short(_arg0); end
  def get_string(*_arg0); end
  def get_uchar(_arg0); end
  def get_uint(_arg0); end
  def get_uint16(_arg0); end
  def get_uint32(_arg0); end
  def get_uint64(_arg0); end
  def get_uint8(_arg0); end
  def get_ulong(_arg0); end
  def get_ulong_long(_arg0); end
  def get_ushort(_arg0); end
  def put(_arg0, _arg1, _arg2); end
  def put_array_of_char(_arg0, _arg1); end
  def put_array_of_double(_arg0, _arg1); end
  def put_array_of_float(_arg0, _arg1); end
  def put_array_of_float32(_arg0, _arg1); end
  def put_array_of_float64(_arg0, _arg1); end
  def put_array_of_int(_arg0, _arg1); end
  def put_array_of_int16(_arg0, _arg1); end
  def put_array_of_int32(_arg0, _arg1); end
  def put_array_of_int64(_arg0, _arg1); end
  def put_array_of_int8(_arg0, _arg1); end
  def put_array_of_long(_arg0, _arg1); end
  def put_array_of_long_long(_arg0, _arg1); end
  def put_array_of_pointer(_arg0, _arg1); end
  def put_array_of_short(_arg0, _arg1); end
  def put_array_of_uchar(_arg0, _arg1); end
  def put_array_of_uint(_arg0, _arg1); end
  def put_array_of_uint16(_arg0, _arg1); end
  def put_array_of_uint32(_arg0, _arg1); end
  def put_array_of_uint64(_arg0, _arg1); end
  def put_array_of_uint8(_arg0, _arg1); end
  def put_array_of_ulong(_arg0, _arg1); end
  def put_array_of_ulong_long(_arg0, _arg1); end
  def put_array_of_ushort(_arg0, _arg1); end
  def put_bytes(*_arg0); end
  def put_char(_arg0, _arg1); end
  def put_double(_arg0, _arg1); end
  def put_float(_arg0, _arg1); end
  def put_float32(_arg0, _arg1); end
  def put_float64(_arg0, _arg1); end
  def put_int(_arg0, _arg1); end
  def put_int16(_arg0, _arg1); end
  def put_int32(_arg0, _arg1); end
  def put_int64(_arg0, _arg1); end
  def put_int8(_arg0, _arg1); end
  def put_long(_arg0, _arg1); end
  def put_long_long(_arg0, _arg1); end
  def put_pointer(_arg0, _arg1); end
  def put_short(_arg0, _arg1); end
  def put_string(_arg0, _arg1); end
  def put_uchar(_arg0, _arg1); end
  def put_uint(_arg0, _arg1); end
  def put_uint16(_arg0, _arg1); end
  def put_uint32(_arg0, _arg1); end
  def put_uint64(_arg0, _arg1); end
  def put_uint8(_arg0, _arg1); end
  def put_ulong(_arg0, _arg1); end
  def put_ulong_long(_arg0, _arg1); end
  def put_ushort(_arg0, _arg1); end
  def read_array_of_char(_arg0); end
  def read_array_of_double(_arg0); end
  def read_array_of_float(_arg0); end
  def read_array_of_int(_arg0); end
  def read_array_of_int16(_arg0); end
  def read_array_of_int32(_arg0); end
  def read_array_of_int64(_arg0); end
  def read_array_of_int8(_arg0); end
  def read_array_of_long(_arg0); end
  def read_array_of_long_long(_arg0); end
  def read_array_of_pointer(_arg0); end
  def read_array_of_short(_arg0); end
  def read_array_of_uchar(_arg0); end
  def read_array_of_uint(_arg0); end
  def read_array_of_uint16(_arg0); end
  def read_array_of_uint32(_arg0); end
  def read_array_of_uint64(_arg0); end
  def read_array_of_uint8(_arg0); end
  def read_array_of_ulong(_arg0); end
  def read_array_of_ulong_long(_arg0); end
  def read_array_of_ushort(_arg0); end
  def read_bytes(_arg0); end
  def read_char; end
  def read_double; end
  def read_float; end
  def read_int; end
  def read_int16; end
  def read_int32; end
  def read_int64; end
  def read_int8; end
  def read_long; end
  def read_long_long; end
  def read_pointer; end
  def read_short; end
  def read_uchar; end
  def read_uint; end
  def read_uint16; end
  def read_uint32; end
  def read_uint64; end
  def read_uint8; end
  def read_ulong; end
  def read_ulong_long; end
  def read_ushort; end
  def size; end

  # Return +true+ if +self+ has a size limit.
  #
  # @return [Boolean]
  #
  # source://ffi//lib/ffi/abstract_memory.rb#40
  def size_limit?; end

  def total; end
  def type_size; end
  def write_array_of_char(_arg0); end
  def write_array_of_double(_arg0); end
  def write_array_of_float(_arg0); end
  def write_array_of_int(_arg0); end
  def write_array_of_int16(_arg0); end
  def write_array_of_int32(_arg0); end
  def write_array_of_int64(_arg0); end
  def write_array_of_int8(_arg0); end
  def write_array_of_long(_arg0); end
  def write_array_of_long_long(_arg0); end
  def write_array_of_pointer(_arg0); end
  def write_array_of_short(_arg0); end
  def write_array_of_uchar(_arg0); end
  def write_array_of_uint(_arg0); end
  def write_array_of_uint16(_arg0); end
  def write_array_of_uint32(_arg0); end
  def write_array_of_uint64(_arg0); end
  def write_array_of_uint8(_arg0); end
  def write_array_of_ulong(_arg0); end
  def write_array_of_ulong_long(_arg0); end
  def write_array_of_ushort(_arg0); end
  def write_bytes(*_arg0); end
  def write_char(_arg0); end
  def write_double(_arg0); end
  def write_float(_arg0); end
  def write_int(_arg0); end
  def write_int16(_arg0); end
  def write_int32(_arg0); end
  def write_int64(_arg0); end
  def write_int8(_arg0); end
  def write_long(_arg0); end
  def write_long_long(_arg0); end
  def write_pointer(_arg0); end
  def write_short(_arg0); end
  def write_uchar(_arg0); end
  def write_uint(_arg0); end
  def write_uint16(_arg0); end
  def write_uint32(_arg0); end
  def write_uint64(_arg0); end
  def write_uint8(_arg0); end
  def write_ulong(_arg0); end
  def write_ulong_long(_arg0); end
  def write_ushort(_arg0); end
end

# source://ffi//lib/ffi/abstract_memory.rb#34
FFI::AbstractMemory::LONG_MAX = T.let(T.unsafe(nil), Integer)

class FFI::ArrayType < ::FFI::Type
  def initialize(_arg0, _arg1); end

  def elem_type; end
  def length; end
end

# source://ffi//lib/ffi/autopointer.rb#33
class FFI::AutoPointer < ::FFI::Pointer
  extend ::FFI::DataConverter

  # @note The safest, and therefore preferred, calling
  #   idiom is to pass a Method as the second parameter. Example usage:
  #
  #   class PointerHelper
  #   def self.release(pointer)
  #   ...
  #   end
  #   end
  #
  #   p = AutoPointer.new(other_pointer, PointerHelper.method(:release))
  #
  #   The above code will cause PointerHelper#release to be invoked at GC time.
  # @note The last calling idiom (only one parameter) is generally only
  #   going to be useful if you subclass {AutoPointer}, and override
  #   #release, which by default does nothing.
  # @overload initialize
  # @overload initialize
  # @overload initialize
  # @overload initialize
  # @raise [TypeError]
  # @return [AutoPointer] a new instance of AutoPointer
  #
  # source://ffi//lib/ffi/autopointer.rb#78
  def initialize(ptr, proc = T.unsafe(nil), &block); end

  # Set +autorelease+ property. See {Pointer Autorelease section at Pointer}.
  #
  # @param autorelease [Boolean]
  # @return [Boolean] +autorelease+
  #
  # source://ffi//lib/ffi/autopointer.rb#109
  def autorelease=(autorelease); end

  # Get +autorelease+ property. See {Pointer Autorelease section at Pointer}.
  #
  # @return [Boolean] +autorelease+
  #
  # source://ffi//lib/ffi/autopointer.rb#115
  def autorelease?; end

  # Free the pointer.
  #
  # @return [nil]
  #
  # source://ffi//lib/ffi/autopointer.rb#102
  def free; end

  class << self
    # Create a new AutoPointer.
    #
    # Override {DataConverter#from_native}.
    #
    # @overload self.from_native
    # @return [AutoPointer]
    #
    # source://ffi//lib/ffi/autopointer.rb#198
    def from_native(val, ctx); end

    # Return native type of AutoPointer.
    #
    # Override {DataConverter#native_type}.
    #
    # @raise [RuntimeError] if class does not implement a +#release+ method
    # @return [Type::POINTER]
    #
    # source://ffi//lib/ffi/autopointer.rb#184
    def native_type; end
  end
end

# CallableReleaser is a {Releaser} used when an {AutoPointer} is defined with a
# Proc or a Method.
#
# source://ffi//lib/ffi/autopointer.rb#173
class FFI::AutoPointer::CallableReleaser < ::FFI::AutoPointer::Releaser
  # Release +ptr+ by using Proc or Method defined at +ptr+
  # {AutoPointer#initialize initialization}.
  #
  # @param ptr [Pointer]
  # @return [nil]
  #
  # source://ffi//lib/ffi/autopointer.rb#174
  def release(ptr); end
end

# DefaultReleaser is a {Releaser} used when an {AutoPointer} is defined
# without Proc or Method. In this case, the pointer to release must be of
# a class derived from AutoPointer with a {release} class method.
#
# source://ffi//lib/ffi/autopointer.rb#160
class FFI::AutoPointer::DefaultReleaser < ::FFI::AutoPointer::Releaser
  # Release +ptr+ using the {release} class method of its class.
  #
  # @param ptr [Pointer]
  # @return [nil]
  #
  # source://ffi//lib/ffi/autopointer.rb#161
  def release(ptr); end
end

# A releaser is an object in charge of release an {AutoPointer}.
#
# @abstract Base class for {AutoPointer}'s releasers.
#
#   All subclasses of Releaser should define a +#release(ptr)+ method.
#
# source://ffi//lib/ffi/autopointer.rb#123
class FFI::AutoPointer::Releaser
  # A new instance of Releaser.
  #
  # @param ptr [Pointer]
  # @param proc [#call]
  # @return [nil]
  #
  # source://ffi//lib/ffi/autopointer.rb#130
  def initialize(ptr, proc); end

  # Returns the value of attribute autorelease.
  #
  # source://ffi//lib/ffi/autopointer.rb#124
  def autorelease; end

  # Sets the attribute autorelease
  #
  # @param value the value to set the attribute autorelease to.
  #
  # source://ffi//lib/ffi/autopointer.rb#124
  def autorelease=(_arg0); end

  # Release pointer if +autorelease+ is set.
  #
  # @param args
  #
  # source://ffi//lib/ffi/autopointer.rb#149
  def call(*args); end

  # Free pointer.
  #
  # @return [nil]
  #
  # source://ffi//lib/ffi/autopointer.rb#138
  def free; end
end

# Represents a C enum whose values are power of 2
#
# Contrary to classical enums, bitmask values are usually combined
# when used.
#
# @example
#   enum {
#   red = (1<<0),
#   green = (1<<1),
#   blue = (1<<2)
#   }
#
# source://ffi//lib/ffi/enum.rb#184
class FFI::Bitmask < ::FFI::Enum
  # @overload initialize
  # @overload initialize
  # @return [Bitmask] a new instance of Bitmask
  #
  # source://ffi//lib/ffi/enum.rb#193
  def initialize(*args); end

  # Get a symbol list or a value from the bitmask
  #
  # @overload []
  # @overload []
  # @overload []
  # @overload []
  # @raise [ArgumentError]
  #
  # source://ffi//lib/ffi/enum.rb#236
  def [](*query); end

  # @param val [Integer]
  # @param ctx unused
  # @return [Array<Symbol, Integer>] list of symbol names corresponding to val, plus an optional remainder if some bits don't match any constant
  #
  # source://ffi//lib/ffi/enum.rb#282
  def from_native(val, ctx); end

  # Get the native value of a bitmask
  #
  # @overload to_native
  # @overload to_native
  #
  # source://ffi//lib/ffi/enum.rb#260
  def to_native(query, ctx); end
end

class FFI::Buffer < ::FFI::AbstractMemory
  def initialize(*_arg0); end

  def +(_arg0); end
  def inspect; end
  def length; end
  def order(*_arg0); end
  def slice(_arg0, _arg1); end

  private

  def initialize_copy(_arg0); end

  class << self
    def alloc_in(*_arg0); end
    def alloc_inout(*_arg0); end
    def alloc_out(*_arg0); end
    def new_in(*_arg0); end
    def new_inout(*_arg0); end
    def new_out(*_arg0); end
  end
end

# source://ffi//lib/ffi/library.rb#32
FFI::CURRENT_PROCESS = T.let(T.unsafe(nil), Object)

FFI::CallbackInfo = FFI::FunctionType

# This module is used to extend somes classes and give then a common API.
#
# Most of methods defined here must be overriden.
#
# source://ffi//lib/ffi/data_converter.rb#35
module FFI::DataConverter
  # Convert from a native type.
  #
  # source://ffi//lib/ffi/data_converter.rb#63
  def from_native(value, ctx); end

  # Get native type.
  #
  # @overload native_type
  # @overload native_type
  #
  # source://ffi//lib/ffi/data_converter.rb#45
  def native_type(type = T.unsafe(nil)); end

  # Convert to a native type.
  #
  # source://ffi//lib/ffi/data_converter.rb#58
  def to_native(value, ctx); end
end

class FFI::DynamicLibrary
  def initialize(_arg0, _arg1); end

  def find_function(_arg0); end
  def find_symbol(_arg0); end
  def find_variable(_arg0); end
  def last_error; end
  def name; end

  class << self
    def last_error; end
    def open(_arg0, _arg1); end
  end
end

FFI::DynamicLibrary::RTLD_ALL_MASK = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_BINDING_MASK = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_DEEPBIND = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_FIRST = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_GLOBAL = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_LAZY = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_LOCAL = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_LOCATION_MASK = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_MEMBER = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_NODELETE = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_NOLOAD = T.let(T.unsafe(nil), Integer)
FFI::DynamicLibrary::RTLD_NOW = T.let(T.unsafe(nil), Integer)

class FFI::DynamicLibrary::Symbol < ::FFI::Pointer
  def inspect; end

  private

  def initialize_copy(_arg0); end
end

# Represents a C enum.
#
# For a C enum:
#  enum fruits {
#    apple,
#    banana,
#    orange,
#    pineapple
#  };
# are defined this vocabulary:
# * a _symbol_ is a word from the enumeration (ie. _apple_, by example);
# * a _value_ is the value of a symbol in the enumeration (by example, apple has value _0_ and banana _1_).
#
# source://ffi//lib/ffi/enum.rb#84
class FFI::Enum
  include ::FFI::DataConverter

  # @overload initialize
  # @overload initialize
  # @return [Enum] a new instance of Enum
  #
  # source://ffi//lib/ffi/enum.rb#97
  def initialize(*args); end

  # Get a symbol or a value from the enum.
  #
  # @overload []
  # @overload []
  #
  # source://ffi//lib/ffi/enum.rb#134
  def [](query); end

  # Get a symbol or a value from the enum.
  #
  # @overload []
  # @overload []
  #
  # source://ffi//lib/ffi/enum.rb#134
  def find(query); end

  # @param val
  # @return symbol name if it exists for +val+.
  #
  # source://ffi//lib/ffi/enum.rb#168
  def from_native(val, ctx); end

  # Returns the value of attribute native_type.
  #
  # source://ffi//lib/ffi/enum.rb#88
  def native_type; end

  # Get the symbol map.
  #
  # @return [Hash]
  #
  # source://ffi//lib/ffi/enum.rb#146
  def symbol_map; end

  # @return [Array] enum symbol names
  #
  # source://ffi//lib/ffi/enum.rb#121
  def symbols; end

  # Returns the value of attribute tag.
  #
  # source://ffi//lib/ffi/enum.rb#87
  def tag; end

  # Get the symbol map.
  #
  # @return [Hash]
  #
  # source://ffi//lib/ffi/enum.rb#146
  def to_h; end

  # Get the symbol map.
  #
  # @return [Hash]
  #
  # source://ffi//lib/ffi/enum.rb#146
  def to_hash; end

  # @param val [Symbol, Integer, #to_int]
  # @param ctx unused
  # @return [Integer] value of a enum symbol
  #
  # source://ffi//lib/ffi/enum.rb#156
  def to_native(val, ctx); end
end

# An instance of this class permits to manage {Enum}s. In fact, Enums is a collection of {Enum}s.
#
# source://ffi//lib/ffi/enum.rb#36
class FFI::Enums
  # @return [nil]
  #
  # source://ffi//lib/ffi/enum.rb#39
  def initialize; end

  # Add an {Enum} to the collection.
  #
  # @param enum [Enum]
  #
  # source://ffi//lib/ffi/enum.rb#47
  def <<(enum); end

  # @param symbol a symbol to find in merge symbol maps of all enums.
  # @return a symbol
  #
  # source://ffi//lib/ffi/enum.rb#66
  def __map_symbol(symbol); end

  # Find a {Enum} in collection.
  #
  # @param query enum tag or part of an enum name
  # @return [Enum]
  #
  # source://ffi//lib/ffi/enum.rb#56
  def find(query); end
end

class FFI::Function < ::FFI::Pointer
  def initialize(*_arg0); end

  def attach(_arg0, _arg1); end
  def autorelease; end
  def autorelease=(_arg0); end
  def autorelease?; end
  def call(*_arg0); end
  def free; end

  private

  def initialize_copy(_arg0); end
end

FFI::FunctionInfo = FFI::FunctionType

class FFI::FunctionType < ::FFI::Type
  def initialize(*_arg0); end

  def param_types; end
  def result_type; end
end

# This module implements a couple of class methods to play with IO.
#
# source://ffi//lib/ffi/io.rb#34
module FFI::IO
  class << self
    # Synonym for IO::for_fd.
    #
    # @param fd [Integer] file decriptor
    # @param mode [String] mode string
    # @return [::IO]
    #
    # source://ffi//lib/ffi/io.rb#39
    def for_fd(fd, mode = T.unsafe(nil)); end

    # A version of IO#read that reads data from an IO and put then into a native buffer.
    #
    # This will be optimized at some future time to eliminate the double copy.
    #
    # @param io [#read] io to read from
    # @param buf [AbstractMemory] destination for data read from +io+
    # @param len [nil, Numeric] maximul number of bytes to read from +io+. If +nil+,
    #   read until end of file.
    # @return [Numeric] length really read, in bytes
    #
    # source://ffi//lib/ffi/io.rb#53
    def native_read(io, buf, len); end
  end
end

module FFI::LastError
  private

  def error; end
  def error=(_arg0); end

  class << self
    def error; end
    def error=(_arg0); end
  end
end

# This module is the base to use native functions.
#
# A basic usage may be:
#  require 'ffi'
#
#  module Hello
#    extend FFI::Library
#    ffi_lib FFI::Library::LIBC
#    attach_function 'puts', [ :string ], :int
#  end
#
#  Hello.puts("Hello, World")
#
# source://ffi//lib/ffi/library.rb#78
module FFI::Library
  # Attach C function +func+ to this module.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @overload attach_function
  # @overload attach_function
  # @param name [#to_s] name of ruby method to attach as
  # @param func [#to_s] name of C function to attach
  # @param args [Array<Symbol>] an array of types
  # @param returns [Symbol] type of return value
  # @param options [Hash] a customizable set of options
  # @raise [FFI::NotFoundError] if +func+ cannot be found in the attached libraries (see {#ffi_lib})
  # @return [FFI::VariadicInvoker]
  #
  # source://ffi//lib/ffi/library.rb#234
  def attach_function(name, func, args, returns = T.unsafe(nil), options = T.unsafe(nil)); end

  # Attach C variable +cname+ to this module.
  #
  # @overload attach_variable
  # @overload attach_variable
  # @raise [FFI::NotFoundError] if +cname+ cannot be found in libraries
  # @return [DynamicLibrary::Symbol]
  #
  # source://ffi//lib/ffi/library.rb#331
  def attach_variable(mname, a1, a2 = T.unsafe(nil)); end

  # Create a new FFI::Bitmask
  #
  # @overload bitmask
  # @overload bitmask
  # @overload bitmask
  # @overload bitmask
  # @overload bitmask
  # @overload bitmask
  # @return [FFI::Bitmask]
  #
  # source://ffi//lib/ffi/library.rb#554
  def bitmask(*args); end

  # @overload callback
  # @overload callback
  # @raise [ArgumentError]
  # @return [FFI::CallbackInfo]
  #
  # source://ffi//lib/ffi/library.rb#384
  def callback(*args); end

  # Create a new {FFI::Enum}.
  #
  # @overload enum
  # @overload enum
  # @overload enum
  # @overload enum
  # @overload enum
  # @overload enum
  # @return [FFI::Enum]
  #
  # source://ffi//lib/ffi/library.rb#511
  def enum(*args); end

  # Find an enum by name.
  #
  # @param name
  # @return [FFI::Enum]
  #
  # source://ffi//lib/ffi/library.rb#561
  def enum_type(name); end

  # Find an enum by a symbol it contains.
  #
  # @param symbol
  # @return [FFI::Enum]
  #
  # source://ffi//lib/ffi/library.rb#568
  def enum_value(symbol); end

  # Set the calling convention for {#attach_function} and {#callback}
  #
  # @note +:stdcall+ is typically used for attaching Windows API functions
  # @param convention [Symbol] one of +:default+, +:stdcall+
  # @return [Symbol] the new calling convention
  # @see http://en.wikipedia.org/wiki/Stdcall#stdcall
  #
  # source://ffi//lib/ffi/library.rb#163
  def ffi_convention(convention = T.unsafe(nil)); end

  # Load native libraries.
  #
  # @param names [Array] names of libraries to load
  # @raise [LoadError] if a library cannot be opened
  # @return [Array<DynamicLibrary>]
  #
  # source://ffi//lib/ffi/library.rb#95
  def ffi_lib(*names); end

  # Sets library flags for {#ffi_lib}.
  #
  # @example
  #   ffi_lib_flags(:lazy, :local) # => 5
  # @param flags [Symbol, …] (see {FlagsMap})
  # @return [Fixnum] the new value
  #
  # source://ffi//lib/ffi/library.rb#196
  def ffi_lib_flags(*flags); end

  # Get FFI libraries loaded using {#ffi_lib}.
  #
  # @raise [LoadError] if no libraries have been loaded (using {#ffi_lib})
  # @return [Array<FFI::DynamicLibrary>] array of currently loaded FFI libraries
  # @see #ffi_lib
  #
  # source://ffi//lib/ffi/library.rb#173
  def ffi_libraries; end

  # Find a type definition.
  #
  # @param t [DataConverter, Type, Struct, Symbol] type to find
  # @return [Type]
  #
  # source://ffi//lib/ffi/library.rb#575
  def find_type(t); end

  # This function returns a list of possible names to lookup.
  #
  # @note Function names on windows may be decorated if they are using stdcall. See
  #   * http://en.wikipedia.org/wiki/Name_mangling#C_name_decoration_in_Microsoft_Windows
  #   * http://msdn.microsoft.com/en-us/library/zxk0tw93%28v=VS.100%29.aspx
  #   * http://en.wikibooks.org/wiki/X86_Disassembly/Calling_Conventions#STDCALL
  #   Note that decorated names can be overridden via def files.  Also note that the
  #   windows api, although using, doesn't have decorated names.
  # @param name [#to_s] function name
  # @param arg_types [Array] function's argument types
  # @return [Array<String>]
  #
  # source://ffi//lib/ffi/library.rb#289
  def function_names(name, arg_types); end

  # Register or get an already registered type definition.
  #
  # To register a new type definition, +old+ should be a {FFI::Type}. +add+
  # is in this case the type definition.
  #
  # If +old+ is a {DataConverter}, a {Type::Mapped} is returned.
  #
  # If +old+ is +:enum+
  # * and +add+ is an +Array+, a call to {#enum} is made with +add+ as single parameter;
  # * in others cases, +info+ is used to create a named enum.
  #
  # If +old+ is a key for type map, #typedef get +old+ type definition.
  #
  # @param old [DataConverter, Symbol, Type]
  # @param add [Symbol]
  # @param info [Symbol]
  # @return [FFI::Enum, FFI::Type]
  #
  # source://ffi//lib/ffi/library.rb#428
  def typedef(old, add, info = T.unsafe(nil)); end

  private

  # Generic enum builder
  #  @param [Class] klass can be one of FFI::Enum or FFI::Bitmask
  #  @param args (see #enum or #bitmask)
  #
  # source://ffi//lib/ffi/library.rb#456
  def generic_enum(klass, *args); end

  class << self
    # Test if extended object is a Module. If not, raise RuntimeError.
    #
    # @param mod extended object
    # @raise [RuntimeError] if +mod+ is not a Module
    # @return [nil]
    #
    # source://ffi//lib/ffi/library.rb#86
    def extended(mod); end
  end
end

# source://ffi//lib/ffi/library.rb#79
FFI::Library::CURRENT_PROCESS = T.let(T.unsafe(nil), Object)

# Flags used in {#ffi_lib}.
#
# This map allows you to supply symbols to {#ffi_lib_flags} instead of
# the actual constants.
#
# source://ffi//lib/ffi/library.rb#182
FFI::Library::FlagsMap = T.let(T.unsafe(nil), Hash)

# source://ffi//lib/ffi/library.rb#80
FFI::Library::LIBC = T.let(T.unsafe(nil), String)

# FFI::ManagedStruct allows custom garbage-collection of your FFI::Structs.
#
# The typical use case would be when interacting with a library
# that has a nontrivial memory management design, such as a linked
# list or a binary tree.
#
# When the {Struct} instance is garbage collected, FFI::ManagedStruct will
# invoke the class's release() method during object finalization.
#
# @example Example usage:
#   module MyLibrary
#   ffi_lib "libmylibrary"
#   attach_function :new_dlist, [], :pointer
#   attach_function :destroy_dlist, [:pointer], :void
#   end
#
#   class DoublyLinkedList < FFI::ManagedStruct
#   @@@
#   struct do |s|
#   s.name 'struct dlist'
#   s.include 'dlist.h'
#   s.field :head, :pointer
#   s.field :tail, :pointer
#   end
#   @@@
#
#   def self.release ptr
#   MyLibrary.destroy_dlist(ptr)
#   end
#   end
#
#   begin
#   ptr = DoublyLinkedList.new(MyLibrary.new_dlist)
#   #  do something with the list
#   end
#   # struct is out of scope, and will be GC'd using DoublyLinkedList#release
#
# source://ffi//lib/ffi/managedstruct.rb#70
class FFI::ManagedStruct < ::FFI::Struct
  # A new instance of FFI::ManagedStruct.
  #
  # @overload initialize
  # @overload initialize
  # @raise [NoMethodError]
  # @return [ManagedStruct] a new instance of ManagedStruct
  #
  # source://ffi//lib/ffi/managedstruct.rb#77
  def initialize(pointer = T.unsafe(nil)); end
end

class FFI::MemoryPointer < ::FFI::Pointer
  def initialize(*_arg0); end

  class << self
    def from_string(_arg0); end
  end
end

FFI::NativeLibrary = FFI::DynamicLibrary
module FFI::NativeType; end
FFI::NativeType::BOOL = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::BUFFER_IN = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::BUFFER_INOUT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::BUFFER_OUT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::FLOAT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::FLOAT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::INT16 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::INT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::INT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::INT8 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::LONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::LONGDOUBLE = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::POINTER = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::STRING = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::UINT16 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::UINT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::UINT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::UINT8 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::ULONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::VARARGS = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::NativeType::VOID = T.let(T.unsafe(nil), FFI::Type::Builtin)

# Exception raised when a function is not found in libraries
#
# source://ffi//lib/ffi/library.rb#58
class FFI::NotFoundError < ::LoadError
  # @return [NotFoundError] a new instance of NotFoundError
  #
  # source://ffi//lib/ffi/library.rb#59
  def initialize(function, *libraries); end
end

class FFI::NullPointerError < ::RuntimeError; end

# This module defines different constants and class methods to play with
# various platforms.
#
# source://ffi//lib/ffi/platform.rb#37
module FFI::Platform
  class << self
    # Test if current OS is a *BSD (include MAC)
    #
    # @return [Boolean]
    #
    # source://ffi//lib/ffi/platform.rb#156
    def bsd?; end

    # Test if current OS is +os+.
    #
    # @param os [String]
    # @return [Boolean]
    #
    # source://ffi//lib/ffi/platform.rb#90
    def is_os(os); end

    # Test if current OS is Mac OS
    #
    # @return [Boolean]
    #
    # source://ffi//lib/ffi/platform.rb#168
    def mac?; end

    # Test if current OS is Solaris (Sun OS)
    #
    # @return [Boolean]
    #
    # source://ffi//lib/ffi/platform.rb#174
    def solaris?; end

    # Test if current OS is a unix OS
    #
    # @return [Boolean]
    #
    # source://ffi//lib/ffi/platform.rb#180
    def unix?; end

    # Test if current OS is Windows
    #
    # @return [Boolean]
    #
    # source://ffi//lib/ffi/platform.rb#162
    def windows?; end
  end
end

FFI::Platform::ADDRESS_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::ADDRESS_SIZE = T.let(T.unsafe(nil), Integer)

# source://ffi//lib/ffi/platform.rb#63
FFI::Platform::ARCH = T.let(T.unsafe(nil), String)

FFI::Platform::BIG_ENDIAN = T.let(T.unsafe(nil), Integer)
FFI::Platform::BYTE_ORDER = T.let(T.unsafe(nil), Integer)

# source://ffi//lib/ffi/platform.rb#109
FFI::Platform::CONF_DIR = T.let(T.unsafe(nil), String)

# source://ffi//lib/ffi/platform.rb#61
FFI::Platform::CPU = T.let(T.unsafe(nil), String)

FFI::Platform::DOUBLE_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::DOUBLE_SIZE = T.let(T.unsafe(nil), Integer)
FFI::Platform::FLOAT_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::FLOAT_SIZE = T.let(T.unsafe(nil), Integer)
FFI::Platform::GNU_LIBC = T.let(T.unsafe(nil), String)
FFI::Platform::INT16_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::INT16_SIZE = T.let(T.unsafe(nil), Integer)
FFI::Platform::INT32_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::INT32_SIZE = T.let(T.unsafe(nil), Integer)
FFI::Platform::INT64_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::INT64_SIZE = T.let(T.unsafe(nil), Integer)
FFI::Platform::INT8_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::INT8_SIZE = T.let(T.unsafe(nil), Integer)

# source://ffi//lib/ffi/platform.rb#103
FFI::Platform::IS_BSD = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#100
FFI::Platform::IS_DRAGONFLYBSD = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#97
FFI::Platform::IS_FREEBSD = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#94
FFI::Platform::IS_GNU = T.let(T.unsafe(nil), String)

# source://ffi//lib/ffi/platform.rb#95
FFI::Platform::IS_LINUX = T.let(T.unsafe(nil), TrueClass)

# source://ffi//lib/ffi/platform.rb#96
FFI::Platform::IS_MAC = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#98
FFI::Platform::IS_NETBSD = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#99
FFI::Platform::IS_OPENBSD = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#101
FFI::Platform::IS_SOLARIS = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#102
FFI::Platform::IS_WINDOWS = T.let(T.unsafe(nil), FalseClass)

# source://ffi//lib/ffi/platform.rb#134
FFI::Platform::LIBC = T.let(T.unsafe(nil), String)

# source://ffi//lib/ffi/platform.rb#113
FFI::Platform::LIBPREFIX = T.let(T.unsafe(nil), String)

# source://ffi//lib/ffi/platform.rb#122
FFI::Platform::LIBSUFFIX = T.let(T.unsafe(nil), String)

FFI::Platform::LITTLE_ENDIAN = T.let(T.unsafe(nil), Integer)
FFI::Platform::LONG_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::LONG_DOUBLE_ALIGN = T.let(T.unsafe(nil), Integer)
FFI::Platform::LONG_DOUBLE_SIZE = T.let(T.unsafe(nil), Integer)
FFI::Platform::LONG_SIZE = T.let(T.unsafe(nil), Integer)

# 64-bit inodes
#
# source://ffi//lib/ffi/platform.rb#108
FFI::Platform::NAME = T.let(T.unsafe(nil), String)

# source://ffi//lib/ffi/platform.rb#38
FFI::Platform::OS = T.let(T.unsafe(nil), String)

# source://ffi//lib/ffi/platform.rb#59
FFI::Platform::OSVERSION = T.let(T.unsafe(nil), Integer)

# source://ffi//lib/ffi/platform.rb#33
class FFI::PlatformError < ::LoadError; end

# source://ffi//lib/ffi/pointer.rb#42
class FFI::Pointer < ::FFI::AbstractMemory
  def initialize(*_arg0); end

  def +(_arg0); end
  def ==(_arg0); end
  def address; end
  def autorelease=(_arg0); end
  def autorelease?; end
  def free; end
  def inspect; end
  def null?; end
  def order(*_arg0); end

  # Read pointer's contents as +type+
  #
  # Same as:
  #  ptr.get(type, 0)
  #
  # @param type [Symbol, Type] of data to read
  # @return [Object]
  #
  # source://ffi//lib/ffi/pointer.rb#152
  def read(type); end

  # Read an array of +type+ of length +length+.
  #
  # @example
  #   ptr.read_array_of_type(TYPE_UINT8, :read_uint8, 4) # -> [1, 2, 3, 4]
  # @param type [Type] type of data to read from pointer's contents
  # @param reader [Symbol] method to send to +self+ to read +type+
  # @param length [Numeric]
  # @return [Array]
  #
  # source://ffi//lib/ffi/pointer.rb#114
  def read_array_of_type(type, reader, length); end

  # Read pointer's contents as a string, or the first +len+ bytes of the
  # equivalent string if +len+ is not +nil+.
  #
  # @param len [nil, Numeric] length of string to return
  # @return [String]
  #
  # source://ffi//lib/ffi/pointer.rb#57
  def read_string(len = T.unsafe(nil)); end

  # Read the first +len+ bytes of pointer's contents as a string.
  #
  # Same as:
  #  ptr.read_string(len)  # with len not nil
  #
  # @param len [Numeric] length of string to return
  # @return [String]
  #
  # source://ffi//lib/ffi/pointer.rb#72
  def read_string_length(len); end

  # Read pointer's contents as a string.
  #
  # Same as:
  #  ptr.read_string  # with no len
  #
  # @return [String]
  #
  # source://ffi//lib/ffi/pointer.rb#81
  def read_string_to_null; end

  def slice(_arg0, _arg1); end
  def to_i; end

  # @return [self]
  #
  # source://ffi//lib/ffi/pointer.rb#142
  def to_ptr; end

  def to_s; end
  def type_size; end

  # Write +value+ of type +type+ to pointer's content
  #
  # Same as:
  #  ptr.put(type, 0)
  #
  # @param type [Symbol, Type] of data to read
  # @param value [Object] to write
  # @return [nil]
  #
  # source://ffi//lib/ffi/pointer.rb#163
  def write(type, value); end

  # Write +ary+ in pointer's contents as +type+.
  #
  # @example
  #   ptr.write_array_of_type(TYPE_UINT8, :put_uint8, [1, 2, 3 ,4])
  # @param type [Type] type of data to write to pointer's contents
  # @param writer [Symbol] method to send to +self+ to write +type+
  # @param ary [Array]
  # @return [self]
  #
  # source://ffi//lib/ffi/pointer.rb#132
  def write_array_of_type(type, writer, ary); end

  # Write +str+ in pointer's contents, or first +len+ bytes if
  # +len+ is not +nil+.
  #
  # @param str [String] string to write
  # @param len [Numeric] length of string to return
  # @return [self]
  #
  # source://ffi//lib/ffi/pointer.rb#101
  def write_string(str, len = T.unsafe(nil)); end

  # Write +len+ first bytes of +str+ in pointer's contents.
  #
  # Same as:
  #  ptr.write_string(str, len)   # with len not nil
  #
  # @param str [String] string to write
  # @param len [Numeric] length of string to return
  # @return [self]
  #
  # source://ffi//lib/ffi/pointer.rb#92
  def write_string_length(str, len); end

  private

  def initialize_copy(_arg0); end

  class << self
    # Return the size of a pointer on the current platform, in bytes
    #
    # @return [Numeric]
    #
    # source://ffi//lib/ffi/pointer.rb#49
    def size; end
  end
end

FFI::Pointer::NULL = T.let(T.unsafe(nil), FFI::Pointer)

# Pointer size
#
# source://ffi//lib/ffi/pointer.rb#45
FFI::Pointer::SIZE = T.let(T.unsafe(nil), Integer)

FFI::SizeTypes = T.let(T.unsafe(nil), Hash)

# This will convert a pointer to a Ruby string (just like `:string`), but
# also allow to work with the pointer itself. This is useful when you want
# a Ruby string already containing a copy of the data, but also the pointer
# to the data for you to do something with it, like freeing it, in case the
# library handed the memory off to the caller (Ruby-FFI).
#
# It's {typedef}'d as +:strptr+.
#
# source://ffi//lib/ffi/types.rb#158
class FFI::StrPtrConverter
  extend ::FFI::DataConverter

  class << self
    # Returns a [ String, Pointer ] tuple so the C memory for the string can be freed
    #
    # @param val [Pointer]
    # @param ctx not used
    # @return [Array(String, Pointer)]
    #
    # source://ffi//lib/ffi/types.rb#166
    def from_native(val, ctx); end
  end
end

# source://ffi//lib/ffi/struct.rb#41
class FFI::Struct
  def initialize(*_arg0); end

  def [](_arg0); end
  def []=(_arg0, _arg1); end

  # @return [Fixnum] Struct alignment
  #
  # source://ffi//lib/ffi/struct.rb#50
  def align; end

  # @return [Fixnum] Struct alignment
  #
  # source://ffi//lib/ffi/struct.rb#50
  def alignment; end

  # Clear the struct content.
  #
  # @return [self]
  #
  # source://ffi//lib/ffi/struct.rb#78
  def clear; end

  def layout; end

  # source://ffi//lib/ffi/struct.rb#61
  def members; end

  def null?; end

  # Get the offset of a field.
  #
  # @return [Numeric]
  #
  # source://ffi//lib/ffi/struct.rb#56
  def offset_of(name); end

  # Get an array of tuples (field name, offset of the field).
  #
  # @return [Array<Array(Symbol, Numeric)>] Array<Array(Symbol, Numeric)>
  #
  # source://ffi//lib/ffi/struct.rb#72
  def offsets; end

  def order(*_arg0); end
  def pointer; end

  # Get struct size
  #
  # @return [Numeric]
  #
  # source://ffi//lib/ffi/struct.rb#45
  def size; end

  # Get {Pointer} to struct content.
  #
  # @return [AbstractMemory]
  #
  # source://ffi//lib/ffi/struct.rb#85
  def to_ptr; end

  # Get array of values from Struct fields.
  #
  # @return [Array]
  #
  # source://ffi//lib/ffi/struct.rb#67
  def values; end

  private

  def initialize_copy(_arg0); end
  def layout=(_arg0); end
  def pointer=(_arg0); end

  class << self
    # @return [Fixnum] Struct alignment
    #
    # source://ffi//lib/ffi/struct.rb#104
    def alignment; end

    def alloc_in(*_arg0); end
    def alloc_inout(*_arg0); end
    def alloc_out(*_arg0); end

    # source://ffi//lib/ffi/struct.rb#165
    def auto_ptr; end

    # source://ffi//lib/ffi/struct.rb#143
    def by_ref(flags = T.unsafe(nil)); end

    # source://ffi//lib/ffi/struct.rb#139
    def by_value; end

    # source://ffi//lib/ffi/struct.rb#123
    def in; end

    # @overload layout
    # @overload layout
    # @return [StructLayout]
    #
    # source://ffi//lib/ffi/struct.rb#205
    def layout(*spec); end

    # source://ffi//lib/ffi/struct.rb#109
    def members; end

    def new_in(*_arg0); end
    def new_inout(*_arg0); end
    def new_out(*_arg0); end

    # Get the offset of a field.
    #
    # @return [Numeric]
    #
    # source://ffi//lib/ffi/struct.rb#119
    def offset_of(name); end

    # Get an array of tuples (field name, offset of the field).
    #
    # @return [Array<Array(Symbol, Numeric)>] Array<Array(Symbol, Numeric)>
    #
    # source://ffi//lib/ffi/struct.rb#114
    def offsets; end

    # source://ffi//lib/ffi/struct.rb#127
    def out; end

    # source://ffi//lib/ffi/struct.rb#131
    def ptr(flags = T.unsafe(nil)); end

    # Get struct size
    #
    # @return [Numeric]
    #
    # source://ffi//lib/ffi/struct.rb#91
    def size; end

    # set struct size
    #
    # @param size [Numeric]
    # @raise [ArgumentError]
    # @return [size]
    #
    # source://ffi//lib/ffi/struct.rb#98
    def size=(size); end

    # source://ffi//lib/ffi/struct.rb#135
    def val; end

    protected

    # source://ffi//lib/ffi/struct.rb#243
    def align(alignment = T.unsafe(nil)); end

    # source://ffi//lib/ffi/struct.rb#243
    def aligned(alignment = T.unsafe(nil)); end

    # source://ffi//lib/ffi/struct.rb#229
    def callback(params, ret); end

    # source://ffi//lib/ffi/struct.rb#248
    def enclosing_module; end

    # source://ffi//lib/ffi/struct.rb#260
    def find_field_type(type, mod = T.unsafe(nil)); end

    # source://ffi//lib/ffi/struct.rb#275
    def find_type(type, mod = T.unsafe(nil)); end

    # source://ffi//lib/ffi/struct.rb#238
    def pack(packed = T.unsafe(nil)); end

    # source://ffi//lib/ffi/struct.rb#238
    def packed(packed = T.unsafe(nil)); end

    private

    # Add array +spec+ to +builder+.
    #
    # @param builder [StructLayoutBuilder]
    # @param spec [Array<Symbol, Integer>]
    # @return [builder]
    #
    # source://ffi//lib/ffi/struct.rb#297
    def array_layout(builder, spec); end

    # Add hash +spec+ to +builder+.
    #
    # @param builder [StructLayoutBuilder]
    # @param spec [Hash]
    # @return [builder]
    #
    # source://ffi//lib/ffi/struct.rb#287
    def hash_layout(builder, spec); end
  end
end

class FFI::Struct::InlineArray
  include ::Enumerable

  def initialize(_arg0, _arg1); end

  def [](_arg0); end
  def []=(_arg0, _arg1); end
  def each; end
  def size; end
  def to_a; end
  def to_ptr; end
end

# source://ffi//lib/ffi/struct.rb#147
class FFI::Struct::ManagedStructConverter < ::FFI::StructByReference
  # @param struct_class [Struct]
  # @raise [NoMethodError]
  # @return [ManagedStructConverter] a new instance of ManagedStructConverter
  #
  # source://ffi//lib/ffi/struct.rb#150
  def initialize(struct_class); end

  # @param ptr [Pointer]
  # @param ctx [nil]
  # @return [Struct]
  #
  # source://ffi//lib/ffi/struct.rb#160
  def from_native(ptr, ctx); end
end

# This class includes the {FFI::DataConverter} module.
#
# source://ffi//lib/ffi/struct_by_reference.rb#33
class FFI::StructByReference
  include ::FFI::DataConverter

  # @param struct_class [Struct]
  # @return [StructByReference] a new instance of StructByReference
  #
  # source://ffi//lib/ffi/struct_by_reference.rb#39
  def initialize(struct_class); end

  # Create a struct from content of memory +value+.
  #
  # @param value [AbstractMemory]
  # @param ctx [nil]
  # @return [Struct]
  #
  # source://ffi//lib/ffi/struct_by_reference.rb#68
  def from_native(value, ctx); end

  # Always get {FFI::Type}::POINTER.
  #
  # source://ffi//lib/ffi/struct_by_reference.rb#47
  def native_type; end

  # Returns the value of attribute struct_class.
  #
  # source://ffi//lib/ffi/struct_by_reference.rb#36
  def struct_class; end

  # @param value [nil, Struct]
  # @param ctx [nil]
  # @return [AbstractMemory] Pointer on +value+.
  #
  # source://ffi//lib/ffi/struct_by_reference.rb#54
  def to_native(value, ctx); end
end

class FFI::StructByValue < ::FFI::Type
  def initialize(_arg0); end

  def layout; end
  def struct_class; end
end

# source://ffi//lib/ffi/struct_layout.rb#36
class FFI::StructLayout < ::FFI::Type
  def initialize(_arg0, _arg1, _arg2); end

  def [](_arg0); end
  def __union!; end
  def fields; end
  def members; end

  # Get the offset of a field.
  #
  # @return [Numeric]
  #
  # source://ffi//lib/ffi/struct_layout.rb#46
  def offset_of(field_name); end

  # Get an array of tuples (field name, offset of the field).
  #
  # @return [Array<Array(Symbol, Numeric)>] Array<Array(Symbol, Numeric)>
  #
  # source://ffi//lib/ffi/struct_layout.rb#40
  def offsets; end

  def to_a; end
end

class FFI::StructLayout::Array < ::FFI::StructLayout::Field
  def get(_arg0); end
  def put(_arg0, _arg1); end
end

class FFI::StructLayout::CharArray < ::FFI::Struct::InlineArray
  def to_s; end
  def to_str; end
end

# An enum {Field} in a {StructLayout}.
#
# source://ffi//lib/ffi/struct_layout.rb#51
class FFI::StructLayout::Enum < ::FFI::StructLayout::Field
  # Get an object of type {#type} from memory pointed by +ptr+.
  #
  # @param ptr [AbstractMemory] pointer on a {Struct}
  # @return [Object]
  #
  # source://ffi//lib/ffi/struct_layout.rb#56
  def get(ptr); end

  # Set +value+ into memory pointed by +ptr+.
  #
  # @param ptr [AbstractMemory] pointer on a {Struct}
  # @param value
  # @return [nil]
  #
  # source://ffi//lib/ffi/struct_layout.rb#64
  def put(ptr, value); end
end

class FFI::StructLayout::Field
  def initialize(*_arg0); end

  def alignment; end
  def get(_arg0); end
  def name; end
  def offset; end
  def put(_arg0, _arg1); end
  def size; end
  def type; end
end

class FFI::StructLayout::Function < ::FFI::StructLayout::Field
  def get(_arg0); end
  def put(_arg0, _arg1); end
end

# source://ffi//lib/ffi/struct_layout.rb#70
class FFI::StructLayout::InnerStruct < ::FFI::StructLayout::Field
  # source://ffi//lib/ffi/struct_layout.rb#71
  def get(ptr); end

  # @raise [TypeError]
  #
  # source://ffi//lib/ffi/struct_layout.rb#75
  def put(ptr, value); end
end

# source://ffi//lib/ffi/struct_layout.rb#81
class FFI::StructLayout::Mapped < ::FFI::StructLayout::Field
  # @return [Mapped] a new instance of Mapped
  #
  # source://ffi//lib/ffi/struct_layout.rb#82
  def initialize(name, offset, type, orig_field); end

  # source://ffi//lib/ffi/struct_layout.rb#87
  def get(ptr); end

  # source://ffi//lib/ffi/struct_layout.rb#91
  def put(ptr, value); end
end

class FFI::StructLayout::Number < ::FFI::StructLayout::Field; end
class FFI::StructLayout::Pointer < ::FFI::StructLayout::Field; end
class FFI::StructLayout::String < ::FFI::StructLayout::Field; end

# Build a {StructLayout struct layout}.
#
# source://ffi//lib/ffi/struct_layout_builder.rb#35
class FFI::StructLayoutBuilder
  # @return [StructLayoutBuilder] a new instance of StructLayoutBuilder
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#39
  def initialize; end

  # Add a field to the builder.
  #
  # @note Setting +offset+ to +nil+ or +-1+ is equivalent to +0+.
  # @param name [String, Symbol] name of the field
  # @param type [Array, DataConverter, Struct, StructLayout::Field, Symbol, Type] type of the field
  # @param offset [Numeric, nil]
  # @return [self]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#123
  def add(name, type, offset = T.unsafe(nil)); end

  # Add an array as a field to the builder.
  #
  # @param count [Numeric] array length
  # @param name [String, Symbol] name of the field
  # @param type [Array, DataConverter, Struct, StructLayout::Field, Symbol, Type] type of the field
  # @param offset [Numeric, nil]
  # @return [self]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#161
  def add_array(name, type, count, offset = T.unsafe(nil)); end

  # Same as {#add}.
  #
  # @param name [String, Symbol] name of the field
  # @param type [Array, DataConverter, Struct, StructLayout::Field, Symbol, Type] type of the field
  # @param offset [Numeric, nil]
  # @return [self]
  # @see #add
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#144
  def add_field(name, type, offset = T.unsafe(nil)); end

  # Add a struct as a field to the builder.
  #
  # @param name [String, Symbol] name of the field
  # @param type [Array, DataConverter, Struct, StructLayout::Field, Symbol, Type] type of the field
  # @param offset [Numeric, nil]
  # @return [self]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#151
  def add_struct(name, type, offset = T.unsafe(nil)); end

  # Returns the value of attribute alignment.
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#37
  def alignment; end

  # Set alignment attribute with +align+ only if it is greater than attribute value.
  #
  # @param align [Numeric]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#56
  def alignment=(align); end

  # Build and return the struct layout.
  #
  # @return [StructLayout]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#167
  def build; end

  # Set packed attribute
  #
  # @overload packed=
  # @overload packed=
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#89
  def packed=(packed); end

  # Returns the value of attribute size.
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#36
  def size; end

  # Set size attribute with +size+ only if +size+ is greater than attribute value.
  #
  # @param size [Numeric]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#50
  def size=(size); end

  # Set union attribute.
  # Set to +true+ to build a {Union} instead of a {Struct}.
  #
  # @param is_union [Boolean]
  # @return [is_union]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#65
  def union=(is_union); end

  # Building a {Union} or a {Struct} ?
  #
  # @return [Boolean]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#73
  def union?; end

  private

  # @param offset [Numeric]
  # @param align [Numeric]
  # @return [Numeric]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#181
  def align(offset, align); end

  # @param name [String, Symbol] name of the field
  # @param type [Array, DataConverter, Struct, StructLayout::Field, Symbol, Type] type of the field
  # @param offset [Numeric, nil]
  # @return [StructLayout::Field]
  #
  # source://ffi//lib/ffi/struct_layout_builder.rb#187
  def field_for_type(name, offset, type); end
end

# List of number types
#
# source://ffi//lib/ffi/struct_layout_builder.rb#100
FFI::StructLayoutBuilder::NUMBER_TYPES = T.let(T.unsafe(nil), Array)

FFI::TYPE_BOOL = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_BUFFER_IN = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_BUFFER_INOUT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_BUFFER_OUT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_FLOAT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_FLOAT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_INT16 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_INT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_INT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_INT8 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_LONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_LONGDOUBLE = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_POINTER = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_STRING = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_UINT16 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_UINT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_UINT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_UINT8 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_ULONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_VARARGS = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TYPE_VOID = T.let(T.unsafe(nil), FFI::Type::Builtin)

class FFI::Type
  def initialize(_arg0); end

  def alignment; end
  def inspect; end
  def size; end
end

FFI::Type::Array = FFI::ArrayType
FFI::Type::BOOL = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::BUFFER_IN = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::BUFFER_INOUT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::BUFFER_OUT = T.let(T.unsafe(nil), FFI::Type::Builtin)

class FFI::Type::Builtin < ::FFI::Type
  def inspect; end
end

FFI::Type::CHAR = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::DOUBLE = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::FLOAT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::FLOAT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::FLOAT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::Function = FFI::FunctionType
FFI::Type::INT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::INT16 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::INT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::INT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::INT8 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::LONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::LONGDOUBLE = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::LONG_LONG = T.let(T.unsafe(nil), FFI::Type::Builtin)

class FFI::Type::Mapped < ::FFI::Type
  def initialize(_arg0); end

  def from_native(*_arg0); end
  def native_type; end
  def to_native(*_arg0); end
  def type; end
end

FFI::Type::POINTER = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::SCHAR = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::SHORT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::SINT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::SLONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::SLONG_LONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::SSHORT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::STRING = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::Struct = FFI::StructByValue
FFI::Type::UCHAR = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::UINT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::UINT16 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::UINT32 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::UINT64 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::UINT8 = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::ULONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::ULONG_LONG = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::USHORT = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::VARARGS = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::Type::VOID = T.let(T.unsafe(nil), FFI::Type::Builtin)
FFI::TypeDefs = T.let(T.unsafe(nil), Hash)

# source://ffi//lib/ffi/library.rb#32
FFI::USE_THIS_PROCESS_AS_LIBRARY = T.let(T.unsafe(nil), Object)

# source://ffi//lib/ffi/union.rb#36
class FFI::Union < ::FFI::Struct
  class << self
    # source://ffi//lib/ffi/union.rb#37
    def builder; end
  end
end

# source://ffi//lib/ffi/version.rb#2
FFI::VERSION = T.let(T.unsafe(nil), String)

# source://ffi//lib/ffi/variadic.rb#34
class FFI::VariadicInvoker
  def initialize(_arg0, _arg1, _arg2, _arg3); end

  # Attach the invoker to module +mod+ as +mname+
  #
  # source://ffi//lib/ffi/variadic.rb#53
  def attach(mod, mname); end

  # source://ffi//lib/ffi/variadic.rb#35
  def call(*args, &block); end

  def invoke(_arg0, _arg1); end
end
