from typing import TextIO

from antlr4.atn.LexerATNSimulator import LexerATNSimulator as LexerATNSimulator
from antlr4.CommonTokenFactory import CommonTokenFactory as CommonTokenFactory
from antlr4.error.Errors import (
    IllegalStateException as IllegalStateException,
    LexerNoViableAltException as LexerNoViableAltException,
    RecognitionException as RecognitionException,
)
from antlr4.InputStream import InputStream as InputStream
from antlr4.Recognizer import Recognizer as Recognizer
from antlr4.Token import CommonToken, Token as Token

class TokenSource: ...

class Lexer(Recognizer, TokenSource):
    __slots__ = (
        "_input",
        "_output",
        "_factory",
        "_tokenFactorySourcePair",
        "_token",
        "_tokenStartCharIndex",
        "_tokenStartLine",
        "_tokenStartColumn",
        "_hitEOF",
        "_channel",
        "_type",
        "_modeStack",
        "_mode",
        "_text",
    )
    DEFAULT_MODE: int
    MORE: int
    SKIP: int
    DEFAULT_TOKEN_CHANNEL: int
    HIDDEN: int
    MIN_CHAR_VALUE: int
    MAX_CHAR_VALUE: int
    _input: InputStream
    _output: TextIO
    _factory: CommonTokenFactory
    _tokenFactorySourcePair: tuple[TokenSource, InputStream]
    _interp: LexerATNSimulator
    _token: Token | None
    _tokenStartCharIndex: int
    _tokenStartLine: int
    _tokenStartColumn: int
    _hitEOF: bool
    _channel: int
    _type: int
    _modeStack: list[int]
    _mode: int
    _text: str | None
    def __init__(self, input: InputStream, output: TextIO = ...) -> None: ...
    def reset(self) -> None: ...
    def nextToken(self) -> Token | None: ...
    def skip(self) -> None: ...
    def more(self) -> None: ...
    def mode(self, m: int) -> None: ...
    def pushMode(self, m: int) -> None: ...
    def popMode(self) -> int: ...
    @property
    def inputStream(self) -> InputStream: ...
    @inputStream.setter
    def inputStream(self, input: InputStream) -> None: ...
    @property
    def sourceName(self) -> str: ...
    def emitToken(self, token: Token) -> None: ...
    def emit(self) -> CommonToken: ...
    def emitEOF(self) -> CommonToken: ...
    @property
    def type(self) -> int: ...
    @type.setter
    def type(self, type: int) -> None: ...
    @property
    def line(self) -> int: ...
    @line.setter
    def line(self, line: int) -> None: ...
    @property
    def column(self) -> int: ...
    @column.setter
    def column(self, column: int) -> None: ...
    def getCharIndex(self) -> int: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, txt: str) -> None: ...
    def getAllTokens(self) -> list[Token]: ...
    def notifyListeners(self, e: LexerNoViableAltException) -> None: ...
    def getErrorDisplay(self, s: str) -> str: ...
    def getErrorDisplayForChar(self, c: str) -> str: ...
    def getCharErrorDisplay(self, c: str) -> str: ...
    def recover(self, re: RecognitionException) -> None: ...
